<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Property_options extends MY_Controller {


	public function __construct() {
		parent::__construct();
		$this->load->model('admin/general_model');
		$this->load->model('admin/property_options_model');
		$this->load->model('admin/category_properties_model');
		$this->load->model('offers_model');
		$this->load->model('user_model');
		$this->load->library('multilang', array('default_lang' => 'hr', 'multilang'=>false));
		$this->load->library('encrypt');
		$this->load->helper('language');
	}

	public function index() {
	if ($this->require_role_admin('admin,manager')) {
			$data['lang']=$this->multilang->get_current();
			$parent_id=$this->input->get('parent_id',true);
			
			//SET MENU AND GET LISTINGS IN CAT
			$this->load->library('menu',array('lang'=>$data['lang'],'parent'=>NULL));
			$data['menu_items']=$this->menu->generate_categories_paths(NULL);
			$data['group_id']=$parent_id;
			$data['group']=$this->category_properties_model->get($parent_id);
			
			$count = $this->property_options_model->count_properties($parent_id);
			//DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
			$param_list=array('sys_name','id as id1','id as edit_id2','id as id3');
			$data['query'] = $this->property_options_model->get_datagrid($param_list,$parent_id);
			
			
			$data = array(
				'content' => $this->load->view('admin/property_options/main_view', $data, TRUE)
			);
			$this->load->view($this->admin_template, $data);
		}
	}
	
	public function add_new(){
		if ($this->require_role_admin('admin')) {
			
		$parent_id=(int)$this->input->get('parent_id',true);
		$group=$this->category_properties_model->get($parent_id);
		$data=array(
			'sys_name'=>$group['sys_name'].'_new_option',
			'group_id'=>$parent_id
			);
		if($id=$this->property_options_model->insert($data)){
			 redirect('/admin/property_options/view/?id='.$id, 'refresh');
		}
		else{
			redirect('/admin/property_options?parent_id='.$parent_id, 'refresh');
		}
		
		echo json_encode($response);
		}
	}
	

	public function remove(){
			if ($this->require_role_admin('admin')) {
			$id=$this->input->get('id');
			$option=$this->property_options_model->get($id);
			if($this->property_options_model->delete($id)){
				redirect('/admin/property_options?parent_id='.$option['group_id'], 'refresh');
			}
			else{
				redirect('/admin/property_options?parent_id='.$option['group_id'], 'refresh');
			}
			echo json_encode($response);
			}
		}
	
	
	public function view() {
	if ($this->require_role_admin('admin')) {
		//GET LANG DATA AND SET MENU
			$data['lang']=$this->multilang->get_current();
			$this->load->library('menu',array('lang'=>$data['lang'],'parent'=>NULL));
			//GET ID AND DATA
			$id=$this->input->get('id',true);
			$data['option']=$this->property_options_model->get($id);
			
			$data['lang_data']=$this->property_options_model->get_trans_bylang($id);
			//UTIL
			$data['countries']=$this->general_model->list_countries();
			$data = array(
				'content' => $this->load->view('admin/property_options/single_view', $data, TRUE)
			);
			$this->load->view($this->admin_template, $data);
		}
	}
	


	public function process(){
		if ($this->require_role_admin('admin')) {
			
			$base_data=array(
				'sys_name'=>$this->input->post('sys_name',true)
			);
			$id=$this->input->post('option_id');
			$lang_name=$this->input->post('lang_name',true);
			$lang_published=$this->input->post('lang_published',true);
			
			if($this->property_options_model->update($id,$base_data)){
				$response['main_data']=1;
				foreach($lang_name as $key=>$l){
					$lang_data=array(
						'name'=>$l,
						'property_id'=>$id,
						'lang_id'=>$key,
					);
				if($this->property_options_model->check_language($id,$key)){
					if($this->property_options_model->update_data($id,$key,$lang_data)){
						$response['lang_data']=1;
					}
					else{
						$response['lang_data']=0;
					}
				}
				else{
					if($this->property_options_model->insert_data($lang_data)){
						$response['lang_data']=1;
					}
					else{
						$response['lang_data']=0;
					}
				}
					
				}
			}
			else{
				$response['main_data']=0;
			}
			
		if($response['main_data']==1 && $response['lang_data']==1)
			$response['response']='Data saved';
		else
			$response['response']='Data not saved';
		//OUTPUT RESULT
		echo json_encode($response);
		}
	}

	public function list_all() {
	if ($this->require_role_admin('admin')) {
			$data['lang']=$this->multilang->get_current();
			
			//SET MENU AND GET LISTINGS IN CAT
			$this->load->library('menu',array('lang'=>$data['lang'],'parent'=>NULL));
			//$data['listings']=$this->listings_model->get_listings($category_id,$published);
			$data['menu_items']=$this->menu->generate_categories_paths(NULL);
			 $parent_id=null;
			$data['category_id']=$parent_id;
            
           
            //DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
            $param_list=array('sys_name','id as id1','id as edit_id2','id as id3');
			$data['query'] = $this->property_options_model->get_datagrid($param_list);
            $count =sizeof($data['query']);
            
			$data = array(
				'content' => $this->load->view('admin/property_options/all_view', $data, TRUE)
			);
			//$data['lang']=$this->general_model->get_lang(1);
			$this->load->view($this->admin_template, $data);
		}
	}
	
	/*
	 * DOHVAĆANJE PODATAKA ZA PREGLED U DATAGRIDU
	 */
	public function datagrid() {
			//CATEGORY ID
			if($this->input->get('parent_id')!=0)
				$parent_id=$this->input->get('parent_id',true);
			else
				$parent_id=NULL;
			
		if ($this->require_role_admin('admin')) {
			//COUNT SE PROVODI PO DEFAULT JEZIKU 1
			$count = $this->property_options_model->count_properties($parent_id);
			//DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
			$param_list=array('sys_name','id as id1','id as edit_id2','id as id3');
			$query = $this->property_options_model->get_datagrid($param_list,$parent_id);
			$data=array();
			if(!empty($query)){
			foreach($query as $q){
				//OBLIKOVANJE PODATAKA ZA ISPIS
				$q['sys_name']=htmlspecialchars($q['sys_name']);
				$data['aaData'][]=array_values($q);
			}
			}
			else{
				$data['aaData']=array();
			}
			echo json_encode($data);

		}

	}

}
