<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Messages extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('admin/general_model');

	}


	function send_group_message(){
		if ($this->require_role_admin('admin,manager')) {
			$data['countries']=$this->general_model->get_sys_countries();
			$data = array(
				'content' => $this->load->view('admin/messages/group_view', $data, TRUE)
			);
			//$data['lang']=$this->general_model->get_lang(1);
			$this->load->view($this->admin_template, $data);
		}
	}

	function process_group_message(){
		if ($this->require_role_admin('admin,manager')) {
			$country_id=$this->input->post('country_id');
			$message=$this->input->post('message');
			if($country_id!='-'){
				$users=$this->db->select('cp.user_id, user_email, country')->join('c1db1.users u','u.user_id=cp.user_id')->from('c1db1.customer_profiles cp')->where('country',$country_id)->get()->result_array();
				$lang=$this->general_model->get_country_lang($country_id);
				$lang=$lang['abbr'];
			}
			else{
				$users=$this->db->select('cp.user_id, user_email, country')->join('c1db1.users u','u.user_id=cp.user_id')->from('c1db1.customer_profiles cp')->get()->result_array();
				$lang='en';
			}
			//WE SPLIT IT INTO CHUNKS
			$prep=array_chunk($users, 50);
			foreach($prep as $p){
				$insert_data=array();
				foreach($p as $sp){
					$insert_data[]=array(
						't_stamp'=>time(),
						'user_id'=>$sp['user_id'],
						'email'=>$sp['user_email'],
						'message'=>$message,
						'country'=>$sp['country'],
						'lang'=>$lang
					);
				}
				$this->db->trans_start();
				//TRANSACTION
					//BATCH INSERT INTO QUE
					$this->db->insert_batch('queue_messages', $insert_data); 
				//TRANSACTION END 
				$this->db->trans_complete();
			}
			$response=array(
						'main_data'=>1,
						'response' => 'Message added to queue'
					);
			echo json_encode($response);
		}
	}
}
