<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Members extends MY_Controller {

	public function __construct() {
		parent::__construct();

		$this->load->library('session');
		$this->load->library('form_validation');
		$this->load->library('validation');
		$this->load->library('Images');

		$this->load->helper('text');
		$this->load->model('admin/members_model');
		$this->load->model('admin/general_model');
	}

	public function index() {

		if ($this->require_role_admin('Admin,Manager')) {

			$data['year'] = date("Y");
			$data['institutions'] = $this->members_model->get_institution();

			if ($this->input->get('institution') && $this->input->get('institution') != '')
				$institution = $this->input->get('institution', true);
			else
				$institution = null;

			if ($this->input->get('year') && $this->input->get('year') != '')
				$year = $this->input->get('year', true);
			else
				$year = date('Y');

			if ($this->input->get('payment') && ($this->input->get('payment') == 'da' || $this->input->get('payment') == 'ne'))
				$payment = $this->input->get('payment', true);
			else
				$payment = null;

			$data['query'] = $this->members_model->list_members($institution, $payment, $year);

			$data['content'] = $this->load->view('admin/members/main_view', $data, TRUE);

			$this->load->view($this->admin_template, $data);
		}

	}

	function view() {

		if ($this->require_role_admin('Admin,Manager')) {

			if (isset($_GET['tid']) && $_GET['tid'] != 0) {
				$data['query_single'] = $this->members_model->get_member($_GET['tid']);
				$data['created_by'] = $this->general_model->user_information($data['query_single']['created_by']);
				$data['last_edit_by'] = $this->general_model->user_information($data['query_single']['last_edit_by']);
			}
			$data['institutions'] = $this->members_model->get_institution();
			$data['types'] = $this->members_model->get_types();
			$data['departments'] = $this->members_model->get_departments();
			$data['year'] = date("Y");
			$data['content'] = $this->load->view('admin/members/single_view', $data, TRUE);

			$this->load->view($this->admin_template, $data);
		}

	}

	public function info($tid = 0) {

		if ($this->require_role_admin('Admin,Manager')) {

			if ($tid != 0) {
				$data['query_single'] = $this->members_model->get_member($tid);
				$data['created_by'] = $this->general_model->user_information($data['query_single']['created_by']);
				$data['last_edit_by'] = $this->general_model->user_information($data['query_single']['last_edit_by']);
			}

			$data[''] = '';

			$this->load->view('admin/templates/info_view', $data);
		}

	}

	function process() {

		if ($this->require_role_admin('Admin,Manager', FALSE)) {

			//FORM VALIDATION
			$this->form_validation->set_message('required', 'Polje <strong>%s</strong> je potrebno upisati.');

			$this->form_validation->set_rules('first_name', 'Ime ', 'required');
			$this->form_validation->set_rules('last_name', 'Prezime', 'required');

			//CHECK IF FORM IS VALID
			if ($this->form_validation->run() == FALSE) {

				$response = array(

					'response' => '<div class="alert alert-danger alert-dismissable margin-l-none"><a class="close" data-dismiss="alert" href="#">&times;</a>' . validation_errors() . '</div>',
					'last_row_id' => '0'
				);
				echo json_encode($response);

			} else {

				// IF ADD MODE //////////////////////////////////////////////////////////////////////////

				if ($this->input->post('item_id') == 0) {

					$files = array(
						'datetime' => date('Y-m-d H:i:s'),
						'edit_datetime' => date('Y-m-d H:i:s'),
						'first_name' => $this->input->post('first_name'),
						'last_name' => $this->input->post('last_name'),
						'start_date' => date('Y-m-d', strtotime($this->input->post('start_date'))),
						'end_date' => date('Y-m-d', strtotime($this->input->post('end_date'))),
						'oib' => $this->input->post('oib'),
						'email' => $this->input->post('email'),
						'type' => $this->input->post('type'),
						'department' => $this->input->post('department'),
						'institution' => $this->input->post('institution'),
						'published' => $this->input->post('published'),
						'created_by' => $this->auth_user_id,
						'last_edit_by' => $this->auth_user_id
					);

					if ($this->members_model->insert($files)) {

						// GET NEW ROW ID //////////////////////////////////////////////////////////////////////////

						$last_row_id = $this->members_model->last_row();
						$last_id = $last_row_id['id'];

						//SAVE LANG
						$member_id = $last_id;

						// SEND RESPONSE //////////////////////////////////////////////////////////////////////////

						$response = array(
							'response' => '<div class="alert alert-success alert-dismissable margin-l-none"><a class="close" data-dismiss="alert" href="#">&times;</a>Sadržaj je uspješno spremljen!</div>',
							'last_row_id' => $last_id
						);
						echo json_encode($response);

					} else {

						$response = array(

							'response' => "<div class='alert alert-danger alert-dismissable margin-l-none'><a class='close' data-dismiss='alert' href='#'>&times;</a>Desila se greška kod spremanja. Molimo kontaktirajte administratora.</div>",
							'last_row_id' => '0'
						);
						echo json_encode($response);
					}

				}

				// IF EDIT MODE //////////////////////////////////////////////////////////////////////////
				else {

					//INSERTING member LANGUAGES
					$member_id = $this->input->post('item_id');

					//UPDATE DATA

					$files = array(
						'datetime' => date('Y-m-d H:i:s'),
						'edit_datetime' => date('Y-m-d H:i:s'),
						'first_name' => $this->input->post('first_name'),
						'last_name' => $this->input->post('last_name'),
						'start_date' => date('Y-m-d', strtotime($this->input->post('start_date'))),
						'end_date' => date('Y-m-d', strtotime($this->input->post('end_date'))),
						'oib' => $this->input->post('oib'),
						'email' => $this->input->post('email'),
						'type' => $this->input->post('type'),
						'department' => $this->input->post('department'),
						'institution' => $this->input->post('institution'),
						'published' => $this->input->post('published'),
						'last_edit_by' => $this->auth_user_id
					);

					if ($this->members_model->update($member_id, $files)) {

						$response = array(

							'response' => '<div class="alert alert-success alert-dismissable margin-l-none"><a class="close" data-dismiss="alert" href="#">&times;</a>Sadržaj je uspješno spremljen!</div>',
							'last_row_id' => $this->input->post('item_id')
						);
						echo json_encode($response);

					} else {

						$response = array(

							'response' => "<div class='alert alert-danger alert-dismissable margin-l-none'><a class='close' data-dismiss='alert' href='#'>&times;</a>Desila se greška kod spremanja. Molimo kontaktirajte administratora.</div>",
							'last_row_id' => $this->input->post('item_id')
						);
						echo json_encode($response);
					}

				}

			}

		}
		// U SLUČAJU ODJAVE
		else {
			$response = array('response' => 'Odjavljeni ste');

			echo json_encode($response);

		}

	}

	public function insert_payment($year, $member) {

		$files = array(
			'date' => date('Y-m-d'),
			'year' => $year,
			'member_id' => $member
		);

		$this->members_model->insert_payment($files);
	}

	public function payments($tid = 0) {

		if ($this->require_role_admin('Admin,Manager')) {

			if ($tid != 0) {
				$data['query_payments'] = $this->members_model->list_payments($tid);
			}

			$data[''] = '';

			$this->load->view('admin/members/payment_view', $data);
		}

	}

	function delete($item_id) {

		if ($this->require_role_admin('Admin,Manager', FALSE)) {

			if ($this->members_model->delete($item_id)) {

				$response = array('response' => '<div class="alert alert-success"><a class="close" data-dismiss="alert" href="#">&times;</a>Sadržaj je uspješno obrisan!</div>', );
				echo json_encode($response);

			} else {

				$response = array('response' => "<div class='alert alert-error'><a class='close' data-dismiss='alert' href='#'>&times;</a>Desila se greška kod brisanja. Molimo da obavijestite administratora.</div>", );
				echo json_encode($response);
			}

		}
		// U SLUČAJU ODJAVE
		else {
			$response = array('response' => lang('admin_general_not_loggedin'), );
			echo json_encode($response);

		}

	}

	function delete_payment($id) {

		if ($this->require_role_admin('Admin,Manager', FALSE)) {

			if ($this->members_model->delete_payment($id)) {

				$response = array('response' => '<div class="alert alert-success"><a class="close" data-dismiss="alert" href="#">&times;</a>Sadržaj je uspješno obrisan!</div>', );
				echo json_encode($response);

			} else {

				$response = array('response' => "<div class='alert alert-error'><a class='close' data-dismiss='alert' href='#'>&times;</a>Desila se greška kod brisanja. Molimo da obavijestite administratora.</div>", );
				echo json_encode($response);
			}

		}
		// U SLUČAJU ODJAVE
		else {
			$response = array('response' => lang('admin_general_not_loggedin'), );
			echo json_encode($response);

		}

	}

	public function print_all() {

		if ($this->require_role_admin('Admin,Manager')) {

			$data['year'] = date("Y");
			$data['institutions'] = $this->members_model->get_institution();

			if ($this->input->get('institution') && $this->input->get('institution') != '')
				$institution = $this->input->get('institution', true);
			else
				$institution = null;

			if ($this->input->get('year') && $this->input->get('year') != '')
				$year = $this->input->get('year', true);
			else
				$year = date('Y');

			if ($this->input->get('payment') && ($this->input->get('payment') == 'da' || $this->input->get('payment') == 'ne'))
				$payment = $this->input->get('payment', true);
			else
				$payment = null;

			$data['query'] = $this->members_model->list_members($institution, $payment, $year);

			$this->load->view('admin/members/print_view', $data);

		}

	}

	public function export_all() {
		if ($this->require_role_admin('Admin,Manager')) {

			$data['year'] = date("Y");
			$data['institutions'] = $this->members_model->get_institution();

			if ($this->input->get('institution') && $this->input->get('institution') != '')
				$institution = $this->input->get('institution', true);
			else
				$institution = null;

			if ($this->input->get('year') && $this->input->get('year') != '')
				$year = $this->input->get('year', true);
			else
				$year = date('Y');

			if ($this->input->get('payment') && ($this->input->get('payment') == 'da' || $this->input->get('payment') == 'ne'))
				$payment = $this->input->get('payment', true);
			else
				$payment = null;

			$query = $this->members_model->list_members_csv($institution, $payment, $year);

			$this->load->helper('csv');
			

			$data = array(array('ID','IME', 'PREZIME', 'OIB', 'USTANOVA', 'ODJEL', 'TIP ČLANSTVA', 'PLAĆANJE'));
			
			foreach ($query as $key => $value) {
				
				if(is_null($value['member_id']))
					$value['member_id']='NEMA UPLATE';
				else
					$value['member_id']='PLAĆENO';
				
				$data[]=$value;
			}
			
			
			array_to_csv($data, 'clanstvo.csv');

		}

	}

}
