<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Main extends MY_Controller {

	public function __construct() {
		parent::__construct();

		$this->load->model('admin/general_model');
		$this->load->model('admin/main_model');

	}

	public function index() {

		if ($this->require_role_admin('Admin,Manager')) {
			
			$data['year'] = date("Y");
			$graph_data=array();
			for($x=$data['year']-15;$x<=$data['year'];$x++){
				$subdata=array();
				$subdata['y']=$x;
				$query_upisi='SELECT COUNT(*) as num FROM members WHERE YEAR(start_date)="'.$x.'"';
				$q1=$this->db->query($query_upisi)->row_array();
				$query_ispisi='SELECT COUNT(*) as num FROM members WHERE YEAR(end_date)="'.$x.'"';
				$q2=$this->db->query($query_ispisi)->row_array();
				$subdata['a']=$q1['num'];
				$subdata['b']=$q2['num'];
				$graph_data[]=$subdata;
			}
			
			$data['num_members'] = $this->main_model->list_members();
			$data['num_payed'] = $this->main_model->list_payed(date('Y'));
			$data['num_not_payed'] = $this->main_model->list_not_payed(date('Y'));
			
			$data['graph'] = json_encode($graph_data);
			$data = array('content' => $this->load->view('admin/main/main_view', $data, TRUE) );
			$this->load->view($this->admin_template, $data);
		}

	}


	public function logout() {
		$this->authentication->logout();

		redirect(secure_site_url('admin/main?logout=1'));
	}
	
	
	public function backup(){
		$this->load->dbutil();
			$prefs = array(
				'format' => 'txt', // gzip, zip, txt
				'filename' => 'mybackup.sql', // File name - NEEDED ONLY WITH ZIP FILES
				'add_drop' => TRUE, // Whether to add DROP TABLE statements to backup file
				'add_insert' => TRUE, // Whether to add INSERT data to backup file
				'newline' => "\n" // Newline character used in backup file
			);

			$backup = &$this->dbutil->backup($prefs);
			
			$file_name = date("Y-m-d").'.sql'; 

			$this->load->helper('file');
			write_file('bb/'.$file_name, $backup);
	}

}
