<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Listings extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('admin/general_model');
		$this->load->model('admin/listings_model');
		$this->load->model('admin/categories_model');
		$this->load->model('offers_model');
		$this->load->model('user_model');
		$this->load->library('multilang', array(
			'default_lang' => 'hr',
			'multilang' => false
		));
		$this->load->library('encrypt');
		$this->load->helper('language');
	}

	public function index() {
		if ($this->require_role_admin('admin,manager')) {

			$data['lang'] = $this->multilang->get_current();
			//COUNTRIES
			$country=$this->general_model->user_countries($this->auth_role,$this->auth_user_id);
			//END COUNTRIES

			//MAIN FILTER BY PUBLISH STATUS
			//PUBLISHED
			if ($this->input->get('f_published') !== FALSE) {
				$published = $this->input->get('f_published', true);
			} else {
				$published = 'all';
			}
			$data['published']=$published;
			//CATEGORY NAV
			//CATEGORY ID
			if ($this->input->get('category_id') != 0) {
				$category_id = $this->input->get('category_id', true);
			} else {
				$category_id = NULL;
			}
			//SET MENU AND GET LISTINGS IN CAT
			$this->load->library('menu', array(
				'lang' => $data['lang'],
				'parent' => NULL
			));
			//$data['listings']=$this->listings_model->get_listings($category_id,$published);
			$data['menu_items'] = $this->menu->generate_categories_paths(NULL);
			$data['breadcrumbs'] = $this->menu->getkeypath($data['menu_items'], $category_id);
			$data['category_id'] = $category_id;
			$data['published'] = $published;

			//PUBLISHED
			if ($this->input->get('f_published') != 'all') {
				$published_grid = $this->input->get('f_published', true);
			} else {
				$published_grid = null;
			}

			//COUNT SE PROVODI PO DEFAULT JEZIKU 1
			$count = $this->listings_model->count_listings($category_id, $published_grid,$country);

			//DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
			$param_list = array(
				'item_id',
				'item_name',
				'item_publish_datetime',
				'item_expired_datetime',
				'item_published',
				'item_id as edit_id',
				'item_id as delete_id'
			);
			$data['query'] = $this->listings_model->get_listings_datagrid($param_list, $category_id, $published_grid,$country);

			$data = array('content' => $this->load->view('admin/listings/main_view', $data, TRUE));
			//$data['lang']=$this->general_model->get_lang(1);
			$this->load->view($this->admin_template, $data);
		}
	}

	function waiting_for_approval() {
		if ($this->require_role_admin('admin,manager')) {
			$data['lang'] = $this->multilang->get_current();
			$this->load->library('menu', array(
				'lang' => $data['lang'],
				'parent' => NULL
			));
			$data['menu_items'] = $this->menu->generate_categories_paths(NULL);
			$data = array('content' => $this->load->view('admin/listings/to_approve_view', $data, TRUE));
			$this->load->view($this->admin_template, $data);
		}
	}
	


	public function view() {
		if ($this->require_role_admin('admin,manager')) {
			//GET LANG DATA AND SET MENU
			$data['lang'] = $this->multilang->get_current();
			$this->load->library('menu', array(
				'lang' => $data['lang'],
				'parent' => NULL
			));
			//COUNTRIES
			//IF MANAGER
			if($this->auth_role =='manager'){
				//GET HIS COUNTRIES
				$current_countries=$this->general_model->get_manager_countries($this->auth_user_id);
			}
			//IF ADMIN
			else if($this->auth_role =='admin'){
				$current_countries=$this->general_model->get_admin_countries();
			}
			if(!empty($current_countries)){
					//MAKE COUNTRY ARRAY
            		$country=array();
					foreach($current_countries as $cc){
						$country[]=$cc['country_id'];
					}
					//IF CERTAIN COUNTRY IS SET AND IS IN HIS COUNTRIES
					if(is_string($this->input->get('country')) && in_array((int)$this->input->get('country'), $country)){
						$country=array($this->input->get('country'));
					}
            	}
			//END COUNTRIES
			//GET ID AND DATA
			$id = $this->input->get('id', true);
			$data['listing'] = $this->listings_model->get_listing($id);
			$data['images']=$this->listings_model->get_images($id);
			$data['documents']=$this->listings_model->get_documents($id);
			//STATISTIC
			$data['view_stats']=$this->_count_single_views($id);
			//IF MANAGER AND NOT ITEM PORTAL MANAGER REDIRECT TO DASHBOARD
			if($this->auth_role =='manager' && !in_array($data['listing']['item_portal'],$country )){
				redirect('admin/dashboard');
			}
			//USER DATA
			$data['user_data'] = $this->user_model->view_user_record($data['listing']['user_id']);
			//SEND MENU ITEMS AND SET BREADCRUMBS
			$data['menu_items'] = $this->menu->generate_categories_paths(NULL);
			$data['breadcrumbs'] = $this->menu->getkeypath($data['menu_items'], $data['listing']['item_category']);
			//FILTRI
			$data['filters'] = $this->listings_model->get_category_properties_groups($data['listing']['item_category']);
			//GET ITEM PROPERTIES AND SET ARRAY FOR FILTER
			$item_properties = $this->listings_model->get_item_properties($id);
			$data['item_properties'] = array();
			if (!empty($item_properties)) {
				foreach ($item_properties as $key => $value) {
					$data['item_properties'][$value['property_id']] = $value;
				}
			}
			//ARRAY CLEANUP
			unset($item_properties);
			$data['item_views']=$this->listings_model->stat_single_total_views($id);
			//UTIL
			$data['countries'] = $this->general_model->list_countries();
			$data['sys_countries'] = $this->general_model->get_sys_countries();
			$data['listing_countries']=$this->listings_model->get_item_countries($id);
			//NUBMER OF OFFERS
			$data['offer_count'] = $this->offers_model->count_offers($data['listing']['item_id']);
			//ALL OFFERS
			$data['offers'] = $this->offers_model->get_item_offers($id);
			$data['refferer']=$this->input->get('f_published');
			$data = array('content' => $this->load->view('admin/listings/single_view', $data, TRUE));
			//$data['lang']=$this->general_model->get_lang(1);
			$this->load->view($this->admin_template, $data);
		}
	}

	function get_notifications($id){
		if ($this->require_role_admin('admin,manager')) {
		$data['item_notifications']=$this->listings_model->get_listing_notifications($id);
		$this->load->view('admin/listings/ajax_list_notifications',$data);
		}
	}

	function _count_listings(){
			$count_listings=$this->listings_model->stat_count_listings_by_date();
			//echo $this->db->last_query();
			$tmp_count=array();
			foreach($count_listings as $cl){
				$tmp_count[]='['.(strtotime($cl['date'])*1000).','.$cl['num'].']';
			}
			$tmp_count=implode(',',$tmp_count);
			$tmp_count='['.$tmp_count.']';
			return $tmp_count;
	}
	
	function _count_single_views($id){
		$list=$this->listings_model->stat_single_views_by_date($id);
		$tmp_count=array();
			foreach($list as $cl){
				$tmp_count[]='['.(strtotime($cl['date'])*1000).','.$cl['count'].']';
			}
			$tmp_count=implode(',',$tmp_count);
			$tmp_count='['.$tmp_count.']';
			return $tmp_count;
	}


	public function process(){
		if ($this->require_role_admin('admin,manager')) {
			
			if ($this->input->post('published')){
				$published = '1';
			}
			else{
				$published = '0';
			}

			if ($this->input->post('promoted')){
				$promoted = '1';
			}
			else{
				$promoted = '0';
			}
			
			$item_id=$this->encrypt->decode(urldecode($this->input->post('sig_data')));
			$data=array(
				//'item_category'		=> $this->input->post('category_id',true),
				//'lang_id'			=>
				'item_origin_id'	=> $this->input->post('country',true),
				//'item_reach_id'		=> $this->input->post('reach',true),
				'item_name'			=> $this->input->post('item_name',true),
				'item_content'		=> $this->input->post('item_content',true),
				//'item_images'		=>
				//'item_documents'	=>
				'item_edit_datetime'	=> date('Y-m-d H:i:s'),
				'item_publish_datetime'	=> date('Y-m-d H:i:s',strtotime($this->input->post('date_start',true))),
				'item_expired_datetime'	=> date('Y-m-d H:i:s',strtotime($this->input->post('date_end',true))),
				//'item_type'			=>	
				'approved_by'			=>$this->auth_user_id,
				'item_published'	=> $published,
				'item_promoted'	=> $promoted,
				);
				if($this->listings_model->update($item_id,$data)){
					$response=array(
						'main_data'=>1,
						'response' => 'This item is updated!'
					);
				}
				else{
					$response=array(
						'main_data'=>0,
						'response' => 'This item is not updated.'
					);
				}
				//FILTERS
				//CLEANUP OLD DATA
				/*
				$this->listings_model->properties_cleanup($item_id);
				//PREP NEW DATA
				$prep_data=array();
				$filters=$this->input->post('filter');
				if(!empty($filters)){
					foreach($filters as $key=>$f){
						$prep_data[]=array(
							'item_id'=>$item_id,
							'property_id'=>$key
						);
					}
					if($this->listings_model->batch_insert_properties($prep_data)){
						$response['prop_data']=1;
					}
					else{
						$response['prop_data']=0;
					}
				}
				//CLEANUP ARRAY
				unset($prep_data);
				 */
				//SAVE COUNTRIES
				if(!$this->input->post('listing_countries')){
					$this->listings_model->purge_countries($item_id);
					$countries_data=array(
						'item_id'=>$item_id,
						'country_id'=>'0'
					);
					$this->listings_model->insert_country($countries_data);
				}
				else{
					//PURGE COUNTRIES FIRST
					$this->listings_model->purge_countries($item_id);
					//INSERT NEW
					$listing_countries=$this->input->post('listing_countries',true);
					foreach($listing_countries as $lc){
						$countries_data=array(
							'item_id'=>$item_id,
							'country_id'=>$lc
						);
						$this->listings_model->insert_country($countries_data);
					}
				}
				
            	
				//OUTPUT RESULT
				echo json_encode($response);
		}
	}


	/*
	 * DOHVAĆANJE PODATAKA ZA PREGLED U DATAGRIDU
	 */
	public function datagrid() {
		//PUBLISHED
		if ($this->input->get('f_published') != 'all')
			$published = $this->input->get('f_published', true);
		else
			$published = null;
		//CATEGORY ID
		if ($this->input->get('category_id') != 0)
			$category_id = $this->input->get('category_id', true);
		else
			$category_id = NULL;

		if ($this->require_role_admin('admin,manager')) {
			//COUNT SE PROVODI PO DEFAULT JEZIKU 1
			$count = $this->listings_model->count_listings($category_id, $published);
			//DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
			$param_list = array(
				'item_name',
				'item_publish_datetime',
				'item_expired_datetime',
				'item_published',
				'item_id as edit_id',
				'item_id as delete_id'
			);
			$query = $this->listings_model->get_listings_datagrid($param_list, $category_id, $published);
			$data = array();
			if (!empty($query)) {
				foreach ($query as $q) {
					//OBLIKOVANJE PODATAKA ZA ISPIS
					$q['item_name'] = htmlspecialchars($q['item_name']);
					$q['item_publish_datetime'] = date('d.m.Y.', strtotime($q['item_publish_datetime']));
					$q['item_expired_datetime'] = date('d.m.Y.', strtotime($q['item_expired_datetime']));
					$data['aaData'][] = array_values($q);
				}
			} else {
				$data['aaData'] = array();
			}
			echo json_encode($data);

		}

	}

	public function to_approve_datagrid() {

		if ($this->require_role_admin('admin,manager')) {
			//COUNT SE PROVODI PO DEFAULT JEZIKU 1
			$count = $this->listings_model->count_listings(null, '0');
			//DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
			$param_list = array(
				'item_name',
				'item_publish_datetime',
				'item_expired_datetime',
				'item_published',
				'item_id as edit_id',
				'item_id as delete_id'
			);
			$query = $this->listings_model->get_listings_datagrid($param_list, null, '0');
			$data = array();
			if (!empty($query)) {
				foreach ($query as $q) {
					//OBLIKOVANJE PODATAKA ZA ISPIS
					$q['item_name'] = htmlspecialchars($q['item_name']);
					$q['item_publish_datetime'] = date('d.m.Y.', strtotime($q['item_publish_datetime']));
					$q['item_expired_datetime'] = date('d.m.Y.', strtotime($q['item_expired_datetime']));
					$data['aaData'][] = array_values($q);
				}
			} else {
				$data['aaData'] = array();
			}
			echo json_encode($data);

		}

	}

//MAIL

	/*SENDS CUSTOM MESSAGE*/
	function notify_user() {
		if ($this->require_role_admin('admin,manager')) {
				$item_name=$this->input->post('item_name',true);
				$item_id=$this->input->post('item_id',true);
				$owner_id=$this->input->post('owner',true);
				$notification=$this->input->post('notification',true);
				/**ADD NOTIFICATION AND SEND MAIL**/
            	$this->load->library('email');
				$this->config->load('email');
				//GET USER DATA FOR EMAIL
            	$user_data=$this->user_model->view_user_record($owner_id);
            	//GENERATE LINK TO ITEM
            	$origin_data=$this->general_model->get_sys_country($user_data->country);
            	$item_link = 'http://www.'.$origin_data['domain'] . '/item/' . url_title($item_name, 'dash', TRUE) . '/' . $item_id;
				
				$lang_data=$this->general_model->get_country_lang($user_data->country);
				$this->lang->load('admin', $lang_data['abbr']);
				
				//GET MESSAGE AND SET LINK
            	$notif_data=array(
					'user_id'=>$owner_id,
					'type_id'=>4,
					'message'=>$notification,
					'item_id'=>$item_id
				);
				//SAVE NOTIFICATION
				$this->general_model->add_notification($notif_data);
				//SEND MAIL
				$sent=$this->email->quick_email( array(
							'subject'        =>  lang('mail_notif_general'),
							'email_template' => 'email_templates/notification',
							'from_name'      => 'no_reply_email_config',
							'template_data'  => array( 'message' => $notification, 'orgin_data' => $origin_data ),
							'to'             => $user_data->user_email,
						
						) );
				if($sent){
					$response=array(
						'status'=>1,
						'response' => 'Message sent'
					);
				}
				else{
					$response=array(
						'status'=>0,
						'response' => 'Message not sent'
					);
				}
				//OUTPUT RESULT
				echo json_encode($response);
		}
	}

	function send_publish_notification(){
		if ($this->require_role_admin('admin,manager')) {
			$id=$this->input->get('item_id',true);
			$listing = $this->listings_model->get_listing($id);
			/**ADD NOTIFICATION AND SEND MAIL**/
			
				$this->load->library('email');
				$this->config->load('email');
			
				//GET USER DATA FOR EMAIL
            	$user_data=$this->user_model->view_user_record($listing['user_id']);
            	//GENERATE LINK TO ITEM
            	$origin_data=$this->general_model->get_sys_country($user_data->country);
				$lang_data=$this->general_model->get_country_lang($user_data->country);
				$this->lang->load('admin', $lang_data['abbr']);
				
            	$item_link = 'http://www.'.$origin_data['domain'] . '/item/' . url_title($listing['item_name']) . '/' . $id;
				//GET MESSAGE AND SET LINK
				$message=str_replace('%link%',$item_link, lang('listing_approved_msg'));
            	$notif_data=array(
					'user_id'=>$listing['user_id'],
					'type_id'=>2,
					'message'=>$message,
					'item_id'=>$id
				);
				
				//SAVE NOTIFICATION
				$this->general_model->add_notification($notif_data);
				$user_settings=$this->user_model->get_user_settings($listing['user_id']);
				
				//SEND MAIL
				if(!isset($user_settings['not_listing_publish']) || $user_settings['not_listing_publish']=='1'){
				$sent=$this->email->quick_email( array(
							// 'subject'        => lang('not_mail_title'),
							'subject'        => lang('mail_notif_general'),
							'email_template' => 'email_templates/notification',
							'from_name'      => 'no_reply_email_config',
							'template_data'  => array( 'message' => $message ),
							'to'             => $user_data->user_email
						) );
				if($sent){
					$response = array(
						'status' => '1',
						'message' => 'Message sent'
					);
					}
					else{
						$response = array(
							'status' => '0',
							'message' => 'Message not sent'
						);
					}
				}
				else{
						$response = array(
							'status' => '0',
							'message' => 'User does not want to recieve messages'
						);
				}
				/**END NOTIFICATION**/
					
			
			echo json_encode($response); 
        }
	}

	//DELETE LISTING
	function delete_listing(){
		if ($this->require_role_admin('admin,manager')) {
			
			$id = $this->input->get('id', true);
			//COUNTRIES
			$country=$this->general_model->user_countries($this->auth_role,$this->auth_user_id);
			//END COUNTRIES
			if($this->listings_model->check_rights($id,$country)){
				if($this->listings_model->delete_listing($id)){
					//PUTANJA DO SADRZAJA
					$dir=FCPATH.'upload/'.$id.'/';
					if(is_dir($dir)){
					try {
	               		//OTKRIVANJE SVIH SADRZAJA U DIREKTORIJU
						$files = new RecursiveIteratorIterator(
						    new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS),
						    RecursiveIteratorIterator::CHILD_FIRST
						);
						//BRISANJE SVEGA
						foreach ($files as $fileinfo) {
						    $todo = ($fileinfo->isDir() ? 'rmdir' : 'unlink');
						    $todo($fileinfo->getRealPath());
						}
						//BRISANJE SAMOG DIREKTORIJA
						rmdir($dir);
		            } catch (MyException $e) {
		                $response = array(
								'response' => 'File removal failed',
								'success' => 0
							);
		            }}
					
					
					$response = array(
								'response' => 'Item deleted',
								'success' => 1
							);
				}
				else{
					$response = array(
								'response' => 'Item not deleted',
								'success' => 0
							);
					}
				}
				else{
					$response = array(
								'response' => 'You have no rights to delete selected item',
								'success' => 0
							);
				}
			echo json_encode($response);
			}
		}

}
