<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Department extends MY_Controller {

    public function __construct() {
        parent::__construct();

        $this->load->library('session');
        $this->load->library('form_validation');
        $this->load->library('validation');
        $this->load->library('Images');

        $this->load->helper('text');
        $this->load->model('admin/department_model');
        $this->load->model('admin/general_model');
    }

    public function index() {

        if ($this->require_role_admin('Admin,Manager')) {

            $data['year'] = date("Y");
            $data['query'] = $this->department_model->list_department();
            $data['content'] = $this->load->view('admin/department/main_view', $data, TRUE);

            $this->load->view($this->admin_template, $data);
        }

    }

    function view() {

        if ($this->require_role_admin('Admin,Manager')) {

            if (isset($_GET['pid']) && $_GET['pid'] != 0) {
                $data['query_single'] = $this->department_model->get_participant($_GET['pid']);
                $data['created_by'] = $this->general_model->user_information($data['query_single']['created_by']);
                $data['last_edit_by'] = $this->general_model->user_information($data['query_single']['last_edit_by']);
            }

            $data['year'] = date("Y");
            $data['content'] = $this->load->view('admin/department/single_view', $data, TRUE);

            $this->load->view($this->admin_template, $data);
        }

    }

    public function info($pid = 0) {

        if ($this->require_role_admin('Admin,Manager')) {

            if ($pid != 0) {
                $data['query_single'] = $this->department_model->get_participant($pid);
                $data['created_by'] = $this->general_model->user_information($data['query_single']['created_by']);
                $data['last_edit_by'] = $this->general_model->user_information($data['query_single']['last_edit_by']);
            }

            $data[''] = '';

            $this->load->view('admin/templates/info_view', $data);
        }

    }

    function process() {

        if ($this->require_role_admin('Admin,Manager', FALSE)) {

            //FORM VALIDATION
            $this->form_validation->set_message('required', 'Polje <strong>%s</strong> je potrebno upisati.');

            $this->form_validation->set_rules('department_name', 'Jezik / program', 'required');

            //CHECK IF FORM IS VALID
            if ($this->form_validation->run() == FALSE) {

                $response = array(
                    'response' => '<div class="alert alert-danger alert-dismissable margin-l-none"><a class="close" data-dismiss="alert" href="#">&times;</a>' . validation_errors() . '</div>',
                    'last_row_id' => '0'
                );
                echo json_encode($response);

            } else {

                // IF ADD MODE //////////////////////////////////////////////////////////////////////////

                if ($this->input->post('item_id') == 0) {

                    $files = array(
                        'datetime' => date('Y-m-d H:i:s'),
                        'edit_datetime' => date('Y-m-d H:i:s'),
                        'department_name' => $this->input->post('department_name'),
                        'published' => $this->input->post('published'),
                        'created_by' => $this->auth_user_id,
                        'last_edit_by' => $this->auth_user_id
                    );

                    if ($this->department_model->insert($files)) {

                        // GET NEW ROW ID //////////////////////////////////////////////////////////////////////////

                        $last_row_id = $this->department_model->last_row();
                        $last_id = $last_row_id['id'];

                        // SEND RESPONSE //////////////////////////////////////////////////////////////////////////

                        $response = array(
                            'response' => '<div class="alert alert-success alert-dismissable margin-l-none"><a class="close" data-dismiss="alert" href="#">&times;</a>Sadržaj je uspješno spremljen!</div>',
                            'last_row_id' => $last_id
                        );
                        echo json_encode($response);

                    } else {

                        $response = array(
                            'response' => "<div class='alert alert-danger alert-dismissable margin-l-none'><a class='close' data-dismiss='alert' href='#'>&times;</a>Desila se greška kod spremanja. Molimo kontaktirajte administratora.</div>",
                            'last_row_id' => '0'
                        );
                        echo json_encode($response);
                    }

                }

                // IF EDIT MODE //////////////////////////////////////////////////////////////////////////
                else {

                    $files = array(
                        'datetime' => date('Y-m-d H:i:s'),
                        'edit_datetime' => date('Y-m-d H:i:s'),
                        'department_name' => $this->input->post('department_name'),
                        'published' => $this->input->post('published'),
                        'last_edit_by' => $this->auth_user_id
                    );

                    if ($this->department_model->update($this->input->post('item_id'), $files)) {

                        $response = array(
                            'response' => '<div class="alert alert-success alert-dismissable margin-l-none"><a class="close" data-dismiss="alert" href="#">&times;</a>Sadržaj je uspješno spremljen!</div>',
                            'last_row_id' => $this->input->post('item_id')
                        );
                        echo json_encode($response);

                    } else {

                        $response = array(
                            'response' => "<div class='alert alert-danger alert-dismissable margin-l-none'><a class='close' data-dismiss='alert' href='#'>&times;</a>Desila se greška kod spremanja. Molimo kontaktirajte administratora.</div>",
                            'last_row_id' => $this->input->post('item_id')
                        );
                        echo json_encode($response);
                    }

                }

            }

        }
        // U SLUČAJU ODJAVE
        else {
            $response = array('response' => 'Odjavljeni ste');

            echo json_encode($response);

        }

    }

    public function insert_department($pid) {

        $files = array('department_id' => $pid);

        $this->department_model->insert_department($files);
    }

    public function department($pid = 0) {

        if ($this->require_role_admin('Admin,Manager')) {

            if ($pid != 0) {
                $data['query_department'] = $this->department_model->list_department($pid);
            }

            $data[''] = '';

            $this->load->view('admin/department/line_view', $data);
        }

    }

    function delete($item_id) {

        if ($this->require_role_admin('Admin,Manager', FALSE)) {

       

            if ($this->department_model->delete($item_id)) {

                $response = array('response' => '<div class="alert alert-success"><a class="close" data-dismiss="alert" href="#">&times;</a>Sadržaj je uspješno obrisan!</div>', );
                echo json_encode($response);

            } else {

                $response = array('response' => "<div class='alert alert-error'><a class='close' data-dismiss='alert' href='#'>&times;</a>Desila se greška kod brisanja. Molimo da obavijestite administratora.</div>", );
                echo json_encode($response);
            }

        }
        // U SLUČAJU ODJAVE
        else {
            $response = array('response' => lang('admin_general_not_loggedin'), );
            echo json_encode($response);

        }
        //

    }

}
