<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Dashboard extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('admin/general_model');
		$this->load->model('admin/listings_model');
	}

	public function index() {
	if ($this->require_role_admin('admin,manager')) {

            //$data['query'] = $this->listings_model->get_chart();
           //var_dump($data['query']);
            
            
			$data['to_approve_count']=$this->listings_model->count_listings(null,'0');
			//COUNTRIES
			$country=$this->general_model->user_countries($this->auth_role,$this->auth_user_id);
			//END COUNTRIES
			$data['count_listings']=$this->_count_listings($country);
			$data['count_offers']=$this->_count_offers($country);
			$data['count_users']=$this->general_model->count_users($country);
			$data['count_total_listings']=$this->listings_model->stat_total_listngs($country);
			$data['count_total_views']=$this->listings_model->stat_total_views($country);
			$data = array(
				'content' => $this->load->view('admin/dashboard/main_view', $data, TRUE)
			);
			//$data['lang']=$this->general_model->get_lang(1);
			$this->load->view($this->admin_template, $data);
		}
	}
	
	
	function _count_listings($country){
			$count_listings=$this->listings_model->stat_count_listings_by_date($country);
		
			
			
			$tmp_count=array();
			foreach($count_listings as $cl){
				$tmp_count[]='['.(strtotime($cl['date'])*1000).','.$cl['num'].']';
			}
			$tmp_count=implode(',',$tmp_count);
			$tmp_count='['.$tmp_count.']';
			return $tmp_count;
	}

	function _count_offers($country){
			$count_listings=$this->listings_model->stat_count_offers_by_date($country);
			//echo $this->db->last_query();
			$tmp_count=array();
			foreach($count_listings as $cl){
				$tmp_count[]='['.(strtotime($cl['date'])*1000).','.$cl['num'].']';
			}
			$tmp_count=implode(',',$tmp_count);
			$tmp_count='['.$tmp_count.']';
			return $tmp_count;
	}
	

	public function logout() {
		$lang = 'hr';
		$this->lang->load('frontend', $lang);
		$data['lang'] = $lang;
		$this->authentication->logout();

		redirect(secure_site_url('/admin'));
	}
}
