<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Cron extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('admin/listings_model');
		$this->load->model('admin/general_model');
		$this->load->helper('language');
		//basic auth
		if($pass=$this->input->get('auth')){
			if($pass!='buybooy')
				die('Access denied');
		}
		else
			die('Access denied');
	}	
	
	//GETS X QUEUE ITEMS
	public function get_mail_queue($x=50){
		$this->db->from('queue_item_notif');
		$this->db->order_by('priority','asc');
		$this->db->limit($x);
		$query = $this->db->get();
        $result = $query->result_array();
		$done=0;
		
		foreach((array)$result as $r){
				/**ADD NOTIFICATION AND SEND MAIL**/
            	$this->load->library('email');
				$this->config->load('email');
				//GENERATE LINK TO ITEM!!!!!!!!!!!!!!!!!
				//$item_link='http://www.'.$r['domain'].'/item/'.url_title($r['name'], 'dash', TRUE).'/'.$r['item_id'];
				$item_link='http://www.www.sellbooy.com.hr/item/'.url_title($r['name'], 'dash', TRUE).'/'.$r['item_id'];
				
				
				//GET USER DATA FOR EMAIL
				$this->lang->load('cron_notifications', $r['lang']);
				switch ($r['type']) {
					case '1':
						$msg=lang('cron_item_expired_notif');
						//$item_link='http://www.'.$r['domain'].'/listing/save?listing_id='.$r['item_id'];
						$item_link='http://www.sellbooy.com.hr/listing/save?listing_id='.$r['item_id'];
						
						break;
					case '2':
						$msg=lang('cron_item_soon_expired_notif');
						//$item_link='http://www.'.$r['domain'].'/listing/save?listing_id='.$r['item_id'];
						$item_link='http://www.sellbooy.com.hr/listing/save?listing_id='.$r['item_id'];
						break;
					default:
						$msg=lang('cron_item_expired_notif');
						break;
				}
				
				$msg=str_replace("%name%", $r['name'], $msg);
				$msg=str_replace("%link%", $item_link, $msg);
				
			
				//GET MESSAGE AND SET LINK
            	$notif_data=array(
					'user_id'=>$r['user_id'],
					'type_id'=>4,
					'message'=>$msg,
					'item_id'=>$r['item_id']
				);
				//SAVE NOTIFICATION
				$notif=$this->general_model->add_notification($notif_data);
				echo $r['user_id'].'-'.$r['item_id'].'-'.$msg.'<br/>';
				//SEND MAIL
				
				$sent=$this->email->quick_email( array(
							'subject'        => lang('cron_item_expired_notif_title'),
							'email_template' => 'email_templates/notification',
							'from_name'      => 'no_reply_email_config',
							'template_data'  => array( 'message' => $msg ),
							'to'             => $r['email']
						) );
			
			//delete queue item
			$deleted=$this->db->delete('queue_item_notif', array('item_id' => $r['item_id'],'type'=>$r['type'])); 
			if($notif && $deleted && $sent)
				$done++;
		}
		//log action to cron logs
		$log_data=array(
			'type'=>'expired',
			'result'=>$x.' processed, '.$done.' successful'
		);
		$this->db->insert('cron_log',$log_data);
	}


	//GETS X MESSAGES QUEUE ITEMS
	public function get_msg_queue($x=50){
		$this->db->from('queue_messages');
		$this->db->order_by('t_stamp','asc');
		$this->db->limit($x);
		$query = $this->db->get();
        $result = $query->result_array();
		$done=0;
		
		foreach((array)$result as $r){
				/**ADD NOTIFICATION AND SEND MAIL**/
            	$this->load->library('email');
				$this->config->load('email');
				
				//GET USER DATA FOR EMAIL
				$this->lang->load('cron_notifications', $r['lang']);	
			
				//GET MESSAGE AND SET LINK
            	$notif_data=array(
					'user_id'=>$r['user_id'],
					'type_id'=>4,
					'message'=>$r['message'],
					'item_id'=>null
				);
				//SAVE NOTIFICATION
				$notif=$this->general_model->add_notification($notif_data);
				echo $r['user_id'].'-'.$r['message'].'<br/>';
				//SEND MAIL
				
				$sent=$this->email->quick_email( array(
							'subject'        => lang('cron_global_msg_title'),
							'email_template' => 'email_templates/global_msg',
							'from_name'      => 'no_reply_email_config',
							'template_data'  => array( 'message' => $r['message'] ),
							'to'             => $r['email']
						) );
			
			//delete queue item
			$deleted=$this->db->delete('queue_messages', array('user_id' => $r['user_id'],'t_stamp'=>$r['t_stamp'])); 
			if($notif && $deleted && $sent)
				$done++;
		}
		//log action to cron logs
		$log_data=array(
			'type'=>'expired',
			'result'=>$x.' processed, '.$done.' successful'
		);
		$this->db->insert('cron_log',$log_data);
	}
	
	//GETS EXPIRED ITEMS; SETS THEIR PUBLISHED STATUS TO 2 AND ADDS THEM TO MAILING QUEUE	
	function get_expired() {
		
		
		
		
		//moj 26774343
			$expired=$this->listings_model->get_recently_expired();
			//WE SPLIT IT INTO CHUNKS
			$prep=array_chunk($expired, 10);
			foreach($prep as $p){
				//PREP DATA
				$update_data=array();
				$insert_data=array();
				
				foreach($p as $i){
					$update_data[]=array(
						'item_id'=>$i['item_id'],
						'item_published'=>'2'
					);
					
					$insert_data[]=array(
						'item_id'=>$i['item_id'],
						'lang'=>$i['lang'],
						//'domain'=>$i['domain'],
						'domain'=>'sellbooy.com.hr',
						'user_id'=>$i['user_id'],
						'email'=>$i['user_email'],
						'name'=>$i['item_name'],
						'type'=>'1'
					);
				}
				$this->db->trans_start();
				//TRANSACTION
					//BATCH UPDATE TO item_published=2
					$this->db->update_batch('items', $update_data, 'item_id'); 
					//BATCH INSERT INTO QUE
					$this->db->insert_batch('queue_item_notif', $insert_data); 
				//TRANSACTION END 
				$this->db->trans_complete();
			}
			if ($this->db->trans_status() === FALSE)
			{
			    echo "Error";
			}
			else{
				echo "Provedeno";
			}
	}
	
	function get_soon_expired($x=3) {
			$expired=$this->listings_model->get_soon_to_expire($x);
			//WE SPLIT IT INTO CHUNKS
			$prep=array_chunk($expired, 10);
			foreach($prep as $p){
				//PREP DATA
				$update_data=array();
				$insert_data=array();
				
				foreach($p as $i){
					
					$insert_data[]=array(
						'item_id'=>$i['item_id'],
						'lang'=>$i['lang'],
						//'domain'=>$i['domain'],
						'domain'=>'sellbooy.com.hr',
						'user_id'=>$i['user_id'],
						'email'=>$i['user_email'],
						'name'=>$i['item_name'],
						'type'=>'2'
					);
				}
				$this->db->trans_start();
				//TRANSACTION
					//BATCH INSERT INTO QUE
					$this->db->insert_batch('queue_item_notif', $insert_data); 
				//TRANSACTION END 
				$this->db->trans_complete();
			}
			if ($this->db->trans_status() === FALSE)
			{
			    echo "Error";
			}
			else{
				echo "Provedeno";
			}
			echo '<pre>';
			print_r($expired);
			echo '</pre>';
	}
	
	//REMOVES EMPTY ITEMS FROM DATABASE OLDER THAN 1 DAY
	function cleanup_empty() {
			if($num=$this->listings_model->cleanup_empty()){
					$response=array(
						'status'=>1,
						'response' => 'Empty items removed'
					);
			}
			else{
				$msg = $this->db->_error_message();
  				$num = $this->db->_error_number();
				$response=array(
						'main_data'=>0,
						'response' => 'Problem with query',
						'error_no' => $num,
						'error_msg' => $msg
					);
			}
		//OUTPUT RESULT
		echo json_encode($response);
		}
}