<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Widgets extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('admin/widget_model');
		$this->load->model('admin/general_model');
		$this->lang->load('admin', $this->config->item('admin_lang'));
		$this->load->helper('language');
		$this->load->helper('url');

	}
	
	
	/*
	 * PREGLED KONTAKTA
	 */

	public function view($lang=1,$type) {

		if ($this->require_role_admin('admin,manager')) {


			//LOADA JEZIK
			$data['lang']=$this->general_model->get_lang($lang);
			$data['query']=$this->widget_model->get($lang,$type);
			$this->lang->load('admin', $data['lang']['abbreviation']);
			//UCITA POSTOJECE PODATKE
			$data['content'] = $this->load->view('admin/widgets/'.$type.'_view', $data, TRUE);

			$this->load->view($this->admin_template, $data);
		}

	}

	
	/*
	 * KREIRANJE I POHRANA SADRZAJA
	 */
	 
	 //LINKS
	public function process_links() {

		if ($this->require_role_admin('admin,manager')) {
					//DATA
						$names=$this->input->post('name',true);
						$urls=$this->input->post('url',true);
						$lang=$this->input->post('lang_id');
						$data=array();
						foreach($names as $key=>$n){
							$data[$key]['name']=$n;
							$data[$key]['url']=prep_url($urls[$key]);
						}
						
					$files=array(
						'language_id'=>$lang,
						'type'=>'links',
						'data'=>json_encode($data)
					);
					if($this->widget_model->check_language($lang,'links'))
						$this->widget_model->update($lang,'links',$files );
					else
						$this->widget_model->insert($files );
					
					$response = array(
								'response' => "Promjene su pohranjene",
								'success' => 1
							);
					echo json_encode($response);
					
			
		}

	}
	
	// FRONTPAGE CONTENT
	
	public function process_fpcontent() {

		if ($this->require_role_admin('admin,manager')) {
					//DATA
						$content=$this->input->post('content',true);
						$url=$this->input->post('url',true);
						$name=$this->input->post('name',true);
						$lang=$this->input->post('lang_id');
						$data=array();
						$data['name']=$name;
						$data['content']=$content;
						$data['url']=prep_url($url);
							
						
					$files=array(
						'language_id'=>$lang,
						'type'=>'fpcontent',
						'data'=>json_encode($data)
					);
					if($this->widget_model->check_language($lang,'fpcontent'))
						$this->widget_model->update($lang,'fpcontent',$files );
					else
						$this->widget_model->insert($files );
					
					$response = array(
								'response' => "Promjene su pohranjene",
								'success' => 1
							);
					echo json_encode($response);
					
			
		}

	}

	

}
