<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Slider extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('admin/slider_model');
		$this->load->model('admin/general_model');
		$this->lang->load('admin', $this->config->item('admin_lang'));
		$this->load->helper('language');
		$this->load->helper('url');

	}
	
	
	/*
	 * PREGLED KONTAKTA
	 */

	public function view($lang=1) {

		if ($this->require_role_admin('admin,manager')) {


			//LOADA JEZIK
			$data['lang']=$this->general_model->get_lang($lang);
			$this->lang->load('admin', $data['lang']['abbreviation']);
			//UCITA POSTOJECE PODATKE
			$data['content'] = $this->load->view('admin/slider/single_view', $data, TRUE);

			$this->load->view($this->admin_template, $data);
		}

	}

	
	/*
	 * KREIRANJE I POHRANA SADRZAJA
	 */
	public function process() {

		if ($this->require_role_admin('admin,manager')) {

					
						
					//KONTAKT PODACI
					$slide_text=$this->input->post('slide_text');
					$image_ids=$this->input->post('image_id');
					foreach($image_ids as $key=>$id){
						$slide_data = array(
							'slide_text'=>$slide_text[$key]
						);
					
						$this->slider_model->update($id,$slide_data );
					}	
					$response = array(
								'response' => "Tekstovi slidera su pohranjeni",
								'success' => 1
							);
					echo json_encode($response);
					
			
		}

	}

	

}
