<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Content_files extends MY_Controller {

	public function __construct() {
		parent::__construct();
		//(filename,language)
		$this->lang->load('admin', $this->config->item('admin_lang'));
		$this->load->helper('language');
		//$this->output->enable_profiler(TRUE);
		//$this->load->model('admin/magazine_model');
		$this->load->library('image_moo');

	}

	function upload_file() {
		if ($this->require_role_admin('admin,manager')) {
			if ($this->input->get('content_id') == 0) {
				return false;
			}

			//DAL JE SLIKA IL DOC
			if (isset($_FILES['doc'])) {
				$file = $_FILES['doc'];
				$fn = $this->safeName(urldecode($file['name']), $this->input->get('content_id'), $this->input->get('type'));
				$path = $this->generate_path($this->input->get('lang'), $this->input->get('source'), $this->input->get('type'), $this->input->get('content_id'));
				$path = $this->check_folder($path);
				$file_path = $path . '/' . $fn;

				//FILE CHECK
				if (file_exists($file_path)) {
					$rand = rand(100, 999);
					$file_path = $path . '/' . $rand . $fn;
				}
				move_uploaded_file($file['tmp_name'], $file_path);
				$file_info = pathinfo($file_path);

				//PARAMS
				$source = $this->input->get('source');
				$type = $this->input->get('type');
				$content_id = $this->input->get('content_id');
				$lang_id = $this->input->get('lang_id');
				$lang = $this->input->get('lang');

				//PREP FOR SAVE TO DB
				if ($source == 'content' && $this->input->get('content_id')) {

					$doc_id = $this->save_to_database('content', $lang_id, $content_id, $file_info, $type);
				}
				$response = array(
					'response' => 'File uploaded via normal POST',
					'content_id' => $content_id,
					'file_path' => $path . '/' . $fn,
					'file_info' => $file_info
				);
				if ($this->input->get('type') == 'document')
					$response['doc_id'] = $doc_id;

			} else {
				// form submit
				$file = $_FILES['pic'];

				$fn = $this->safeName($file['name'], $this->input->get('content_id'), $this->input->get('type'));
				$path = $this->generate_path($this->input->get('lang'), $this->input->get('source'), $this->input->get('type'), $this->input->get('content_id'));
				$path = $this->check_folder($path);
				$file_path = $path . '/' . $fn;
				//FILE CHECK
				if ($this->input->get('type') != 'single_image' && file_exists($file_path)) {
					$rand = rand(100, 999);
					$file_path = $path . '/' . $rand . $fn;
				}
				move_uploaded_file($file['tmp_name'], $file_path);

				//PARAMS
				$source = $this->input->get('source');
				$type = $this->input->get('type');
				$content_id = $this->input->get('content_id');
				$lang_id = $this->input->get('lang_id');
				$lang = $this->input->get('lang');

				//RESIZE IMAGES AND GET PATHS
				if ($this->input->get('type') == 'single_image') {
					$img_config = array(
						'image_path' => $file_path,
						'delete_orig' => true,
						'quality' => 90,
						'size_large' => 1500,
						'size_medium' => 600,
						'size_small' => 150
					);

					//BRISEMO ORGINAL SLIKU
					$paths = $this->resize_image($img_config);
				}
				else if ($this->input->get('type') == 'main_slider') {
					$img_config = array(
						'image_path' => $file_path,
						'delete_orig' => false,
						'quality' => 90,
						'size_medium' => 600,
					);

					//BRISEMO ORGINAL SLIKU
					$paths = $this->resize_image($img_config);
				} 
				
				else {
					$img_config = array(
						'image_path' => $file_path,
						'delete_orig' => true,
						'quality' => 90,
						'size_large' => 1500,
						'size_medium' => 600,
						'size_small' => 150
					);
					//OSTAVLJAMO ORGINAL
					$paths = $this->resize_image($img_config);
				}

				//PREP FOR SAVE TO DB
				if ($source == 'content' && $this->input->get('content_id')) {

					$img_id = $this->save_to_database('content', $lang_id, $content_id, $paths, $type);
				}
				//SLIDER
				if ($source == 'slider') {

					$img_id = $this->save_to_database('slider', $lang_id, 1, $paths, $type);
				}

				$response = array(
					'response' => 'File uploaded via normal POST',
					'content_id' => $content_id,
					'file_path' => $path . '/' . $fn,
					'images' => $paths,
				);
				if ($type == 'gallery' || $type == 'main_slider')
					$response['img_id'] = $img_id;
			}
			echo json_encode($response);

		}
	}

	function delete_image() {
		if ($this->require_role_admin('admin,manager')) {
			//GALLERY
			if ($this->input->post('type') == 'content') {
				$this->load->model('admin/gallery_model');
				$image = $this->gallery_model->get_content_image($this->input->post('id'));
				if (!empty($image)) {
					$files = json_decode($image['image_data']);
					if (!empty($files)) {
						foreach ($files as $f) {
							if (file_exists(FCPATH . $f))
								unlink(FCPATH . $f);
						}
						if ($this->gallery_model->delete_content_image($this->input->post('id'))) {
							$response = array(
								'response' => "Slika je uklonjena",
								'success' => '1'
							);
							echo json_encode($response);
						} else {
							$response = array(
								'response' => "Slika nije uklonjena",
								'success' => '0'
							);
							echo json_encode($response);
						}
					} else {
						$response = array(
							'response' => "Slika ne postoji",
							'success' => '1'
						);
						echo json_encode($response);
					}

				} else {
					$response = array(
						'response' => "Slika ne postoji",
						'success' => '1'
					);
					echo json_encode($response);
				}
			}
			//SLIDER
			if ($this->input->post('type') == 'main_slider') {
				$this->load->model('admin/slider_model');
				$image = $this->slider_model->get_image($this->input->post('id'));
				if (!empty($image)) {
					$files = json_decode($image['image_data']);
					if (!empty($files)) {
						foreach ($files as $f) {
							if (file_exists(FCPATH . $f))
								unlink(FCPATH . $f);
						}
						if ($this->slider_model->delete_image($this->input->post('id'))) {
							$response = array(
								'response' => "Slika je uklonjena",
								'success' => '1'
							);
							echo json_encode($response);
						} else {
							$response = array(
								'response' => "Slika nije uklonjena",
								'success' => '0'
							);
							echo json_encode($response);
						}
					} else {
						$response = array(
							'response' => "Slika ne postoji",
							'success' => '1'
						);
						echo json_encode($response);
					}

				} else {
					$response = array(
						'response' => "Slika ne postoji",
						'success' => '1'
					);
					echo json_encode($response);
				}
			}

		}
	}

	function delete_single_image() {
		if ($this->require_role_admin('admin,manager')) {
			$this->load->model('admin/content_model');
			$image = $this->content_model->get_single($this->input->post('content_id'), $this->input->post('lang_id'));

			if (!empty($image)) {
				$files = json_decode($image['image'], true);
				if (!empty($files)) {
					foreach ($files as $f) {
						if (file_exists(FCPATH . $f))
							unlink(FCPATH . $f);
					}
					//CISCENJE DIREKTORIJA KAKO BI SREDILI ZAOSTALE FAJLOVE
					$file_info = pathinfo(reset($files));
					$cur_dir = glob($file_info['dirname'] . '/*');
					// get all file names
					foreach ($cur_dir as $f) {// iterate files
						if (is_file($f))
							unlink($f);
						// delete file
					}
					if ($this->content_model->update_translation($this->input->post('content_id'), $this->input->post('lang_id'), array('image' => ''))) {
						$response = array(
							'response' => "Slika je uklonjena",
							'success' => '1'
						);
						echo json_encode($response);
					} else {
						$response = array(
							'response' => "Slika nije uklonjena",
							'success' => '0'
						);
						echo json_encode($response);
					}
				} else {
					$response = array(
						'response' => "Slika ne postoji",
						'success' => '1'
					);
					echo json_encode($response);
				}

			} else {
				$response = array(
					'response' => "Slika ne postoji",
					'success' => '1'
				);
				echo json_encode($response);
			}

		}
	}

	function delete_document() {
		if ($this->require_role_admin('admin,manager')) {
			$this->load->model('admin/documents_model');

			if ($this->input->post('type') == 'content') {
				$doc = $this->documents_model->get_content_document($this->input->post('id'));
				if (!empty($doc)) {

					if (file_exists(FCPATH . $doc['document']))
						unlink(FCPATH . $doc['document']);

					if ($this->documents_model->delete_content_document($this->input->post('id'))) {
						$response = array(
							'response' => "Dokument je uklonjen",
							'success' => '1'
						);
						echo json_encode($response);
					} else {
						$response = array(
							'response' => "Dokument nije uklonjen",
							'success' => '0'
						);
						echo json_encode($response);
					}
				} else {
					$response = array(
						'response' => "Dokument ne postoji u bazi",
						'success' => '1'
					);
					echo json_encode($response);
				}
			}

		}
	}

	function manage_gallery_publish() {
		if ($this->require_role_admin('admin,manager')) {
			$this->load->model('admin/gallery_model');
			$id = $this->input->post('id');
			$published = $this->input->post('published');
			if ($this->gallery_model->update_content($id, array('published' => $published))) {
				$response = array('success' => '1');
				echo json_encode($response);
			} else {
				$response = array('success' => '0');
				echo json_encode($response);
			}

		}
	}
	
	function manage_slider_publish() {
		if ($this->require_role_admin('admin,manager')) {
			$this->load->model('admin/slider_model');
			$id = $this->input->post('id');
			$published = $this->input->post('published');
			if ($this->slider_model->update($id, array('published' => $published))) {
				$response = array('success' => '1');
				echo json_encode($response);
			} else {
				$response = array('success' => '0');
				echo json_encode($response);
			}

		}
	}

	function manage_document_publish() {
		if ($this->require_role_admin('admin,manager')) {
			$this->load->model('admin/documents_model');
			$id = $this->input->post('id');
			$published = $this->input->post('published');
			if ($this->documents_model->update_content($id, array('published' => $published))) {
				$response = array('success' => '1');
				echo json_encode($response);
			} else {
				$response = array('success' => '0');
				echo json_encode($response);
			}

		}
	}

	function save_sorted_gallery() {
		if ($this->require_role_admin('admin,manager')) {
			$data = $this->input->post('image_list');
			$x = 0;
			foreach ($data as $item) {

				$x++;

				$files = array('position' => $x, );
				$this->load->model('admin/gallery_model');
				$this->gallery_model->update_content($item['value'], $files);

			}
		}
	}
	
	function save_sorted_slider() {
		if ($this->require_role_admin('admin,manager')) {
			$data = $this->input->post('image_list');
			$x = 0;
			foreach ($data as $item) {

				$x++;

				$files = array('position' => $x, );
				$this->load->model('admin/slider_model');
				$this->slider_model->update($item['value'], $files);

			}
		}
	}

	function save_sorted_documents() {
		if ($this->require_role_admin('admin,manager')) {
			$data = $this->input->post('document_list');
			$name_data = $this->input->post('document_names');
			$x = 0;
			foreach ($data as $key => $item) {

				$x++;

				$files = array(
					'position' => $x,
					'name' => $name_data[$key]['value']
				);
				$this->load->model('admin/documents_model');
				$this->documents_model->update_content($item['value'], $files);

			}
		}
	}

	private function resize_image($img_config) {
		//DEFAULT CONFIG
		$image_path = $img_config['image_path'];
		unset($img_config['image_path']);

		if (empty($img_config)) {
			$img_config = array(
				'delete_orig' => true,
				'quality' => 90,
				'size_large' => 1500,
				'size_medium' => 600,
				'size_small' => 150
			);
		}

		//GET IMAGE INFO
		$file_info = pathinfo($image_path);
		$file_name = $file_info['filename'];
		$file_extension = $file_info['extension'];
		$file_path = $file_info['dirname'];

		if (isset($img_config['size_large'])) {
			$this->image_moo->set_jpeg_quality($img_config['quality'])->load($image_path)->resize($img_config['size_large'])->save_pa('large_', '', TRUE);
			$paths['large_image'] = $file_path . '/large_' . $file_name . '.' . $file_extension;
		}

		if (isset($img_config['size_medium'])) {
			$this->image_moo->set_jpeg_quality($img_config['quality'])->load($image_path)->resize_crop($img_config['size_medium'], $img_config['size_medium'])->save_pa('medium_', '', TRUE);
			$paths['medium_image'] = $file_path . '/medium_' . $file_name . '.' . $file_extension;
		}

		if (isset($img_config['size_small'])) {
			$this->image_moo->set_jpeg_quality($img_config['quality'])->load($image_path)->resize($img_config['size_small'])->save_pa('small_', '', TRUE);
			$paths['small_image'] = $file_path . '/small_' . $file_name . '.' . $file_extension;
		}
		//DELETE ORIGINAL IMAGE
		if ($img_config['delete_orig'])
			unlink($image_path);
		else
			$paths['original'] = $image_path;

		return $paths;
	}

	private function save_to_database($source, $lang, $content_id, $file_data, $type) {
		//GALLERY
		if ($source == 'content' && $type == 'gallery') {
			$data = array(
				'content_id' => $content_id,
				'datetime' => date('Y-m-d H:i:s'),
				'image_data' => json_encode($file_data),
				'language_id' => $lang
			);
			$this->load->model('admin/gallery_model');
			if ($insert_id = $this->gallery_model->insert_content($data))
				return $insert_id;
		}
		//SLIDER
		else if ($source == 'slider' && $type == 'main_slider') {
			$data = array(
				'slider_id' => 1,
				'datetime' => date('Y-m-d H:i:s'),
				'image_data' => json_encode($file_data),
				'language_id' => $lang
			);
			$this->load->model('admin/slider_model');
			if ($insert_id = $this->slider_model->insert($data))
				return $insert_id;
		} 
		//SINGLE IMAGE
		else if ($source == 'content' && $type == 'single_image') {
			$data = array('image' => json_encode($file_data), );
			$this->load->model('admin/content_model');
			if ($this->content_model->check_language($content_id, $lang))
				return $this->content_model->update_translation($content_id, $lang, $data);
			else {
				$data['content_id'] = $content_id;
				$data['lang_id'] = $lang;
				return $this->content_model->insert_translation($data);
			}

		} 
		//DOCUMENTS
		else if ($source == 'content' && $type == 'document') {
			$data = array(
				'content_id' => $content_id,
				'datetime' => date('Y-m-d H:i:s'),
				'document' => $file_data['dirname'] . '/' . $file_data['basename'],
				'name' => $file_data['basename'],
				'language_id' => $lang
			);
			$this->load->model('admin/documents_model');
			if ($insert_id = $this->documents_model->insert_content($data))
				return $insert_id;
		}

	}

	/*
	 * UTILLY FUNCTIONS
	 */

	private function generate_path($lang, $source, $type, $id) {
		$path = $source . '/' . $id . '/' . $type . '/' . $lang;
		return $path;
	}

	private function check_folder($path) {
		$real_path = 'uploads/' . $path;
		if (is_dir($real_path)) {
			return $real_path;
		} else {
			if (mkdir($real_path, 0755, true))
				return $real_path;
			else
				return FALSE;
		}

	}

	private function safeName($string, $content_id, $type = "gallery") {
		$path_info = pathinfo($string);
		$extension = $path_info['extension'];
		$name = $path_info['filename'];
		$not_allowed = array(
			'php',
			'html',
			'js',
			'jsp'
		);
		if (is_int(array_search($extension, $not_allowed))) {
			die('FILE TYPE NOT ALLOWED');
		}

		if ($type == 'gallery' || $type == 'document') {
			$string = preg_replace('/[^\\pL\d]+/u', '_', $name);
			$string = trim($string, '_');
			$string = iconv('utf-8', 'us-ascii//TRANSLIT', $string);
			$string = strtolower($string);
			$string = preg_replace('/[^-\w]+/', '', $string);
		} else if ($type == 'single_image') {
			$string = $content_id;
		}

		return $string . '.' . $extension;
	}

}
