<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Contact extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('admin/contact_model');
		$this->load->model('admin/general_model');
		$this->lang->load('admin', $this->config->item('admin_lang'));
		$this->load->helper('language');
		$this->load->helper('url');

	}
	
	
	/*
	 * PREGLED KONTAKTA
	 */

	public function view($lang=1) {

		if ($this->require_role_admin('admin,manager')) {


			//LOADA JEZIK
			$data['lang']=$this->general_model->get_lang($lang);
			$this->lang->load('admin', $data['lang']['abbreviation']);
			//UCITA POSTOJECE PODATKE
			$data['query'] = $this->contact_model->get_contact($lang);
			$data['content'] = $this->load->view('admin/contact/'.$data['lang']['abbreviation'].'/single_view', $data, TRUE);

			$this->load->view($this->admin_template, $data);
		}

	}

	
	/*
	 * KREIRANJE I POHRANA SADRZAJA
	 */
	public function process() {

		if ($this->require_role_admin('admin,manager')) {

					//COORDINATES
						$coordinates=array();
						$addresses = $this->input->post('address');
						$lnglat = $this->input->post('lnglat');
						
						if(!empty($lnglat)){
						foreach($lnglat as $key => $c){
							$coordinates[$key]['address']=$addresses[$key];
							$coordinates[$key]['coordinates']=$lnglat[$key];
						}
						$coordinates_json=json_encode($coordinates);
						
						}
						else{
							$coordinates_json="";
						}
					
					$contact_json=json_encode($this->input->post('contact'));	
						
					//KONTAKT PODACI
						$contact_data = array(
							'language_id' => $this->input->post('lang_id'),
							'contact_data' => $contact_json,
							'coordinates'=>$coordinates_json,
						);
						
					//PROVJERA DAL VEĆ POSTOJI PRIJEVOD
					if($this->contact_model->check_language($this->input->post('lang_id'))){
						if($this->contact_model->update($this->input->post('lang_id'),$contact_data )){
							$response = array(
								'response' => 'Izmjene su pohranjene',
								'success' => 1
							);
						}
					}
					else {
						if($this->contact_model->insert($contact_data )){
							$response = array(
								'response' => 'Podaci su pohranjeni',
								'success' => 1
							);
						}
						else {
							$response = array(
								'response' => "Tekstualni dio sadržaja nije pohranjen",
								'success' => 0
							);
						}
						
					}
					
					//OUTPUT RESPONSE
					echo json_encode($response);
					
			
		}

	}

	

}
