<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Category_properties extends MY_Controller {


	public function __construct() {
		parent::__construct();
		$this->load->model('admin/general_model');
		$this->load->model('admin/category_properties_model');
		$this->load->model('admin/categories_model');
		$this->load->model('offers_model');
		$this->load->model('user_model');
		$this->load->library('multilang', array('default_lang' => 'hr', 'multilang'=>false));
		$this->load->library('encrypt');
		$this->load->helper('language');
	}

	public function index() {
	if ($this->require_role_admin('admin,manager')) {
			$data['lang']=$this->multilang->get_current();
			$parent_id=$this->input->get('parent_id',true);
			
			//SET MENU AND GET LISTINGS IN CAT
			$this->load->library('menu',array('lang'=>$data['lang'],'parent'=>NULL));
			$data['menu_items']=$this->menu->generate_categories_paths(NULL);
			$data['category_id']=$parent_id;
			$data['category']=$this->categories_model->get_category($parent_id);
			
			//CATEGORY ID
			if($this->input->get('parent_id')!=0)
				$parent_id=$this->input->get('parent_id',true);
			else
				$parent_id=NULL;
			
			//COUNT SE PROVODI PO DEFAULT JEZIKU 1
			$count = $this->category_properties_model->count_groups($parent_id);
			//DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
			$param_list=array('sys_name','id as id1','id as edit_id2','id as id3','id as id5');
			$data['query'] = $this->category_properties_model->get_groups_datagrid($param_list,$parent_id);
			
			
			$data = array(
				'content' => $this->load->view('admin/category_properties/main_view', $data, TRUE)
			);
			$this->load->view($this->admin_template, $data);
		}
	}
	
	public function add_new(){
		if ($this->require_role_admin('admin')) {
			
		$parent_id=(int)$this->input->get('parent_id',true);
		$category=$this->categories_model->get_category($parent_id);
		$data=array(
			'sys_name'=>$category['ref_name'].'_new',
			'type'=>'checkbox'
			);
		if($id=$this->category_properties_model->insert($data)){
			//CONNECT TO CATEGORY
			$cat_connect=array(
				'category_id'=>$parent_id,
				'group_id'=>$id
			);
			$this->category_properties_model->connect_to_cat($cat_connect);
			 redirect('/admin/category_properties/view/?id='.$id, 'refresh');
		}
		else{
			redirect('/admin/category_properties?parent_id='.$parent_id, 'refresh');
		}
		
		echo json_encode($response);
		}
	}
	

	public function remove(){
			if ($this->require_role_admin('admin')) {
			$id=$this->input->get('id');
			$group=$this->category_properties_model->get($id);
			if($this->category_properties_model->delete($id)){
				redirect('/admin/category_properties?parent_id='.$group['category_id'], 'refresh');
			}
			else{
				redirect('/admin/category_properties?parent_id='.$group['category_id'], 'refresh');
			}
			echo json_encode($response);
			}
		}
	
	
	public function view() {
	if ($this->require_role_admin('admin')) {
		//GET LANG DATA AND SET MENU
			$data['lang']=$this->multilang->get_current();
			$this->load->library('menu',array('lang'=>$data['lang'],'parent'=>NULL));
			//GET ID AND DATA
			$id=$this->input->get('id',true);
			$data['group']=$this->category_properties_model->get($id);
			
			$data['lang_data']=$this->category_properties_model->get_group_trans_bylang($id);
			//UTIL
			$data['countries']=$this->general_model->list_countries();
			$data = array(
				'content' => $this->load->view('admin/category_properties/single_view', $data, TRUE)
			);
			$this->load->view($this->admin_template, $data);
		}
	}
	


	public function process(){
		if ($this->require_role_admin('admin')) {
			
			$base_data=array(
				'sys_name'=>$this->input->post('sys_name',true),
				'type'=>$this->input->post('type',true),
			);
			$id=$this->input->post('group_id');
			$lang_name=$this->input->post('lang_name',true);
			$lang_published=$this->input->post('lang_published',true);
			
			if($this->category_properties_model->update($id,$base_data)){
				$response['main_data']=1;
				foreach($lang_name as $key=>$l){
					$lang_data=array(
						'name'=>$l,
						'group_id'=>$id,
						'lang_id'=>$key,
					);
				if($this->category_properties_model->check_language($id,$key)){
					if($this->category_properties_model->update_data($id,$key,$lang_data)){
						$response['lang_data']=1;
					}
					else{
						$response['lang_data']=0;
					}
				}
				else{
					if($this->category_properties_model->insert_data($lang_data)){
						$response['lang_data']=1;
					}
					else{
						$response['lang_data']=0;
					}
				}
					
				}
			}
			else{
				$response['main_data']=0;
			}
		if($response['main_data']==1 && $response['lang_data']==1)
			$response['response']='Data saved';
		else
			$response['response']='Data not saved';
		//OUTPUT RESULT
		echo json_encode($response);
		}
	}

	/*
	 * DOHVAĆANJE PODATAKA ZA PREGLED U DATAGRIDU
	 */
	public function datagrid() {
			//CATEGORY ID
			if($this->input->get('parent_id')!=0)
				$parent_id=$this->input->get('parent_id',true);
			else
				$parent_id=NULL;
			
		if ($this->require_role_admin('admin')) {
			//COUNT SE PROVODI PO DEFAULT JEZIKU 1
			$count = $this->category_properties_model->count_groups($parent_id);
			//DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
			$param_list=array('sys_name','id as id1','id as edit_id2','id as id3','id as id5');
			$query = $this->category_properties_model->get_groups_datagrid($param_list,$parent_id);
			$data=array();
			if(!empty($query)){
			foreach($query as $q){
				//OBLIKOVANJE PODATAKA ZA ISPIS
				$q['sys_name']=htmlspecialchars($q['sys_name']);
				$data['aaData'][]=array_values($q);
			}
			}
			else{
				$data['aaData']=array();
			}
			echo json_encode($data);

		}

	}

}
