<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Categories extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('admin/general_model');
		$this->load->model('admin/categories_model');
		//$this->lang->load('admin', $this->config->item('admin_lang'));
		$this->load->helper('language');
		$this->load->helper('url');
		$this->load->library('multilang', array('default_lang' => 'hr', 'multilang'=>false));

	}
	
	/*
	 * PREGLED SVIH SADRZAJA
	 */

	public function index($lang=1) {

		if ($this->require_role_admin('admin,manager')) {
			
			$data['lang']=$this->multilang->get_current();
			
			$data['content'] = $this->load->view('admin/categories/categories_nav_view', $data, TRUE);

			$this->load->view($this->admin_template, $data);
		}

	}
	
	function get_data(){
		if ($this->require_role_admin('admin,manager')) {
		$id=$this->input->post('id');
		$data['base_data']=$this->categories_model->get_category($id);
		$data['lang_data']=$this->categories_model->get_category_trans_bylang($id);
		$this->load->view('admin/categories/form_view',$data);
		}
	}
	
	public function add_new(){
		if ($this->require_role_admin('admin,manager')) {
		$data=array(
			'ref_name'=>'item',
			'parent_id'=>NULL
			);
		if($id=$this->categories_model->insert($data)){
			$response=array(
				'id'=>$id
			);
		}
		else{
			$response=array(
				'id'=>0
			);
		}
		
		echo json_encode($response);
		}
	}
	
	public function remove(){
		if ($this->require_role_admin('admin,manager')) {
		$id=$this->input->post('id');
		if($id=$this->categories_model->delete($id)){
			$response=array(
				'response'=>1
			);
		}
		else{
			$response=array(
				'response'=>0
			);
		}
		echo json_encode($response);
		}
	}
	
	
	public function update(){
		if ($this->require_role_admin('admin,manager')) {
			$base_data=array(
				'ref_name'=>$this->input->post('ref_name',true)
			);
			$id=$this->input->post('category_id');
			$lang=$this->input->post('lang',true);
			$published=$this->input->post('published',true);
			
			if($this->categories_model->update($id,$base_data)){
				foreach($lang as $key=>$l){
					$lang_data=array(
						'category_name'=>$l,
						'category_id'=>$id,
						'language_id'=>$key,
						'published'=>$published[$key]
					);
				if($this->categories_model->check_language($id,$key))
					$this->categories_model->update_data($id,$key,$lang_data);
				else
					$this->categories_model->insert_data($lang_data);
				}
			}
			
		}
		
	}
	
	public function generate_nested(){
		$data['lang']=$this->multilang->get_current();
		$this->load->library('menu',array('lang'=>$data['lang'],'parent'=>NULL,'type'=>'admin'));
		$menu_items=$this->menu->generate_categories_paths(NULL);
		echo $this->menu->sortableNestedList($menu_items);
	}
	
	public function update_relationships(){
		if ($this->require_role_admin('admin,manager')) {
			$json_structure=$this->input->post('structure');
			$structure=json_decode($json_structure,true);
			$this->structure_crawler($structure);
		}
		
	}
	
	private function structure_crawler($structure,$parent=NULL){
		foreach ($structure as $s){
			$data=array(
				'category_id'=>$s['id'],
				'parent_id'=>$parent
			);
			$this->categories_model->update($s['id'],$data);
			if(isset($s['children']))
				$this->structure_crawler($s['children'],$s['id']);
		}
	}

}
