<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Advertising extends MY_Controller {
	
	public $advertising_key='sa314n1hfjalfhhlgvu3';

    public function __construct() {
        parent::__construct();
        $this->load->model('admin/general_model');
        $this->load->model('admin/advertising_model');
        $this->load->model('admin/categories_model');
        //OVAJMODEL ISPOD MOŽEMO IZBACITI KAD SE NAPRAVI U ADVETISING
        $this->load->model('admin/listings_model');
        $this->load->model('user_model');
        $this->load->library('multilang', array('default_lang' => 'hr', 'multilang' => false));
        $this->load->library('encrypt');
        $this->load->helper('language');
    }

    public function clients() {
        if ($this->require_role_admin('admin,manager')) {
            $data['lang'] = $this->multilang->get_current();
			//COUNTRIES
			$country=$this->general_model->user_countries($this->auth_role,$this->auth_user_id);
			//END COUNTRIES
            //Active
            if ($this->input->get('active') != '')
                $active = $this->input->get('active', true);
            else
                $active = null;
            //Type
            if ($this->input->get('type') != 0)
                $type = $this->input->get('type', true);
            else
                $type = NULL;
            // //Country
            // if ($this->input->get('country') != 0)
                // $country = $this->input->get('country', true);
            // else
                // $country = NULL;
			
			//$count = $this->advertising_model->count_clients($current_countries, $type, $active);
            //DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
            $param_list = array('client_name', 'contact_data','active','added_datetime', 'c.name as country_name', 'active', 'acl.id as edit_id', 'acl.id as delete_id');
            $query = $this->advertising_model->get_clients_datagrid($param_list, $country, $type, $active);
            if (!empty($query)) {
                foreach ($query as $q) {
                    //OBLIKOVANJE PODATAKA ZA ISPIS
                    $q['client_name'] = htmlspecialchars($q['client_name']);
                    $q['added_datetime'] = date('d.m.Y.', strtotime($q['added_datetime']));
                }
            }
			$data['clients']=$query;
            //SET MENU AND GET CLIENTS
            $data['params']['country'] = $country;
            $data['params']['active'] = $active;
            $data['params']['type'] = $type;
            $data = array('content' => $this->load->view('admin/advertising/clients_main_view', $data, TRUE));
            $this->load->view($this->admin_template, $data);
        }
    }

    public function view_client() {
        if ($this->require_role_admin('admin,manager')) {
        	$this->load->library('encrypt');
            //GET LANG DATA AND SET MENU
            $data['lang'] = $this->multilang->get_current();
			
			//ID
            if ($this->input->get('id') != 0)
                $id = $this->input->get('id', true);
            else
                $id = NULL;
			
			if(is_null($id)){
				$data=array(
					'client_name'=>'new client',
					'added_datetime'=>date('d-m-Y h:i:s'),
					//'country'=>$country,
					//'client_type'=>$type
					);
				if($id=$this->advertising_model->insert_client($data)){
					 redirect('/admin/advertising/view_client?id='.$id, 'refresh');
				}
				else{
					redirect('/admin/advertising'.($param_list=http_build_query($params))?'?'.$param_list:null, 'refresh');
				}
			}
			else{
				$data['query'] = $this->advertising_model->get_client($id);
				$data['campaigns']=$this->advertising_model->get_campaigns_datagrid('*',null,$id);
			}
            
            
            //COUNTRIES
			$country=$this->general_model->user_countries($this->auth_role,$this->auth_user_id);
			//END COUNTRIES
            
            
            
            
            //UTIL
            $data['countries'] = $this->general_model->list_countries();
            $data = array('content' => $this->load->view('admin/advertising/clients_single_view', $data, TRUE));
            $this->load->view($this->admin_template, $data);
        }
    }

	//DELETE CLIENT
	function delete_client(){
		if ($this->require_role_admin('admin,manager')) {
			//COUNTRIES
			$country=$this->general_model->user_countries($this->auth_role,$this->auth_user_id);
			//END COUNTRIES
			$id = $this->input->get('id', true);
			$client_campaigns=$this->advertising_model->get_campaigns_datagrid('acm.id as id',null,$id);
			if($this->advertising_model->check_rights_client($id,$country)){
				if($this->advertising_model->delete_client($id)){
					if(!empty($client_campaigns)){
						foreach($client_campaigns as $cc){
							//PUTANJA DO SADRZAJA
							$dir=FCPATH.'banners/'.$cc['id'].'/';
						if(is_dir($dir)){
							//OTKRIVANJE SVIH SADRZAJA U DIREKTORIJU
							$files = new RecursiveIteratorIterator(
							    new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS),
							    RecursiveIteratorIterator::CHILD_FIRST
							);
							//BRISANJE SVEGA
							foreach ($files as $fileinfo) {
							    $todo = ($fileinfo->isDir() ? 'rmdir' : 'unlink');
							    $todo($fileinfo->getRealPath());
							}
							//BRISANJE SAMOG DIREKTORIJA
							rmdir($dir);
							}
						}
					}
					
					$response = array(
								'response' => 'Client deleted',
								'success' => 1
							);
				}
				else{
					$response = array(
								'response' => 'Client not deleted',
								'success' => 0
							);
					}
			}
			echo json_encode($response);
			}
		}
	
    

    public function campaigns() {
        if ($this->require_role_admin('admin,manager')) {
            $data['lang'] = $this->multilang->get_current();
			//COUNTRIES
			$country=$this->general_model->user_countries($this->auth_role,$this->auth_user_id);
			//END COUNTRIES
            //MAIN FILTER BY ACTIVE STATUS
            //ACTIVE
            if ($this->input->get('active') !== FALSE)
                $active = $this->input->get('active', true);
            else
                $active = null;
            //CLIENT ID
            if ($this->input->get('client_id') != 0)
                $client = $this->input->get('client_id', true);
            else
                $client = NULL;
            //SET MENU AND GET CAMPAIGNS
            $data['active'] = $active;
            $data['client'] = $client;
			$param_list = array('name', 'start_datetime','end_datetime', 'acl.client_name as client_name', 'acm.active as active', 'acm.id as id');
			$data['campaigns']= $this->advertising_model->get_campaigns_datagrid($param_list,$country, $client,$active);
            $data = array('content' => $this->load->view('admin/advertising/campaigns_main_view', $data, TRUE));
            $this->load->view($this->admin_template, $data);
        }
    }

    public function view_campaign() {
        if ($this->require_role_admin('admin,manager')) {
            //GET LANG DATA AND SET MENU
            $data['lang'] = $this->multilang->get_current();
			//COUNTRIES
			//IF MANAGER
			if($this->auth_role =='manager'){
				//GET HIS COUNTRIES
				$current_countries=$this->general_model->get_manager_countries($this->auth_user_id);
			}
			//IF ADMIN
			else if($this->auth_role =='admin'){
				$current_countries=$this->general_model->get_admin_countries();
			}
			if(!empty($current_countries)){
					//MAKE COUNTRY ARRAY
            		$country=array();
					foreach($current_countries as $cc){
						$country[]=$cc['country_id'];
					}
					//IF CERTAIN COUNTRY IS SET AND IS IN HIS COUNTRIES
					if(is_string($this->input->get('country')) && in_array((int)$this->input->get('country'), $country)){
						$country=array($this->input->get('country'));
					}
            	}
			//END COUNTRIES
            //ID
            $id = $this->input->get('id', true);
			//IF JUST 0 SHOW CLIENT AND NAME FORM
			if($id ==0){
				//IF 0 AND NAME AND CLIENT CREATE NEW
				if($this->input->post('campaign_name') && $this->input->post('client')){
					$data=array(
					'name'=>$this->input->post('campaign_name',true),
					'client_id'=>$this->input->post('client',true),
					'create_datetime'=>date('d-m-Y h:i:s'),
					);
					if($id=$this->advertising_model->insert_campaign($data)){
						 redirect('/admin/advertising/view_campaign?id='.$id, 'refresh');
					}
					else{
						redirect('/admin/advertising/campaigns'.($param_list=http_build_query($params))?'?'.$param_list:null, 'refresh');
					}
				}
			}
			//SHOW EXISTING
			else if($id >0){
				$data['query'] = $this->advertising_model->get_campaign($id);
				//BANNERS
				$data['banners']=$this->advertising_model->get_banners_datagrid(array('abn.id as id, uc.name as target_country,source as location,aps.name as position_name'),$id);
				$total_stat=$this->advertising_model->campaign_statistic_total($id);
				$tmp_stat=array();
				foreach($total_stat as $key=>$ts){
					if(is_null($ts['event_type']))
						continue;
					else{
						$tmp_stat[$ts['event_type']]=$ts;
					}	
				}
				$data['campaign_statistic_total']=$tmp_stat;
				$data['campaign_statistic_daily_views']=$this->_campaign_views($id);
				$data['campaign_statistic_daily_clicks']=$this->_campaign_clicks($id);
				
				if($this->input->get('report')){
					$data['campaign_statistic_byday_total']=$this->advertising_model->campaign_statistic_by_day_total($id);
					ini_set('memory_limit', '800M');
					$html = $this->load->view('admin/advertising/campaign_report_view', $data, true);
				
					$this->load->library('pdf');
					$pdf = $this->pdf->load();
					$pdf->WriteHTML($html);
					$pdf->Output('campaign-'.url_title($data['query']['name'], '-', TRUE).'.pdf','I');
					die();
				}
			}
            
            
            if($this->auth_role =='manager'){
                $current_countries=$this->general_model->get_manager_countries($this->auth_user_id);
                if(!empty($current_countries)){
                    $country=array();
                    foreach($current_countries as $cc){
                        $country[]=$cc['country_id'];
                    }
                }
            }
                
            else 
                $country=null;
            
            $data['count_listings']=$this->_count_listings($country);
            
            
            //ALLOWED CLIENTS
			$data['clients']=$this->advertising_model->get_clients_datagrid('acl.id as id, client_name',$country);
            //UTIL
            $data['countries'] = $this->general_model->list_countries();
			if($id==0)
				$data = array('content' => $this->load->view('admin/advertising/campaign_primary_single_view', $data, TRUE));
			else
           	 	$data = array('content' => $this->load->view('admin/advertising/campaign_single_view', $data, TRUE));
            $this->load->view($this->admin_template, $data);
        }
    }

	//DELETE CAMPAIGN
	function delete_campaign(){
		if ($this->require_role_admin('admin,manager')) {
			//COUNTRIES
			$country=$this->general_model->user_countries($this->auth_role,$this->auth_user_id);
			//END COUNTRIES
			$id = $this->input->get('id', true);
			$campaign_data=$this->advertising_model->get_campaign($id);
			//CHECK IF CLIENT IS FROM USERS MANAGMENT AREA
			if($this->advertising_model->check_rights_campaign($id,$country)){
				if($this->advertising_model->delete_campaign($id)){
					//PUTANJA DO SADRZAJA
					$dir=FCPATH.'banners/'.$id.'/';
					if(is_dir($dir)){
						//OTKRIVANJE SVIH SADRZAJA U DIREKTORIJU
						$files = new RecursiveIteratorIterator(
						    new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS),
						    RecursiveIteratorIterator::CHILD_FIRST
						);
						//BRISANJE SVEGA
						foreach ($files as $fileinfo) {
						    $todo = ($fileinfo->isDir() ? 'rmdir' : 'unlink');
						    $todo($fileinfo->getRealPath());
						}
						//BRISANJE SAMOG DIREKTORIJA
						rmdir($dir);
					}
					$response = array(
								'response' => 'Campaign deleted',
								'success' => 1
							);
				}
				else{
					$response = array(
								'response' => 'Campaign not deleted',
								'success' => 0
							);
					}
			}
			echo json_encode($response);
			}
		}

	public function view_banner() {
        if ($this->require_role_admin('admin,manager')) {
        	//COUNTRIES
			$country=$this->general_model->user_countries($this->auth_role,$this->auth_user_id);
			//END COUNTRIES
			$id = $this->input->get('id', true);
			 if ($id && $id >0 ){
			 	$id = $this->input->get('id', true);
				$data['query'] = $this->advertising_model->get_banner($id);
				$data['position'] = $this->advertising_model->get_single_positions($data['query']['position']);
				$data['campaign'] = $this->advertising_model->get_campaign($data['query']['campaign_id']);
				if($data['position']['source']=='category'){
					$banner_categories= $this->advertising_model->get_banner_categories($data['query']['id']);
					$bann_cat=array();
					if(!empty($banner_categories)){
						foreach($banner_categories as $bc){
							$bann_cat[$bc['category_id']]=$bc;
						}
					}
					$data['banner_categories'] = $bann_cat;
					unset($bann_cat);
				}
				else{
					$data['banner_categories'] = null;
				}

			 }
                
            else if($id==0)
                {
                	$campaign_id=$this->input->get('campaign_id',true);
					$data=array(
						'campaign_id'=>$campaign_id,
						);
					if($id=$this->advertising_model->insert_banner($data)){
						 redirect('/admin/advertising/view_banner/?id='.$id, 'refresh');
					}
					else{
						redirect('/admin/advertising/view_campaing?id='.$parent_id, 'refresh');
					}
                }
			 else{
			 	$id=null;
			 }
			 
			$this->load->library('menu',array('lang'=>array('id'=>2)));
			$data['category_paths']=$this->menu->generate_categories_paths();
			$data['count_listings']=$this->_count_listings($country);
			$data['banner_id']=$id;
			$data['banner_statistic_total']=$this->advertising_model->banner_statistic_total($id);

			$data['banner_statistic_daily_views']=$this->_banner_views($id);
			$data['banner_statistic_daily_clicks']=$this->_banner_clicks($id);
			
			//statistika
			if($this->input->get('report')){
				$data['campaign'] = $this->advertising_model->get_campaign($data['query']['campaign_id']);
				if($this->input->get('from') && $this->input->get('to')){
					$from=$this->input->get('from',true);
					$to=$this->input->get('to',true);
					$from=date('Y-m-d',strtotime($from));
					$to=date('Y-m-d',strtotime($to));
					$data['campaign']['start_datetime']=$from;
					$data['campaign']['end_datetime']=$to;
					$data['banner_statistic_total']=$this->advertising_model->banner_statistic_total_datespan($id,$from,$to);
					$data['banner_statistic_daily_total']=$this->advertising_model->banner_statistic_by_day_datespan($id,$from,$to);
				}
				else
					$data['banner_statistic_daily_total']=$this->advertising_model->banner_statistic_by_day_total($id);
				ini_set('memory_limit', '800M');

				$html = $this->load->view('admin/advertising/banner_report_view', $data, true);
			
				$this->load->library('pdf');
				$pdf = $this->pdf->load();
				$pdf->WriteHTML($html);
				$pdf->Output('banner.pdf','I');
				die();
			}


			$data['countries'] =$this->general_model->user_countries($this->auth_role,$this->auth_user_id,true);
			$data = array('content' => $this->load->view('admin/advertising/banners_single_view', $data, TRUE));
            $this->load->view($this->admin_template, $data);
		}
	}


	//DELETE BANNER
	function delete_banner(){
		if ($this->require_role_admin('admin,manager')) {
			//COUNTRIES
			$country=$this->general_model->user_countries($this->auth_role,$this->auth_user_id);
			//END COUNTRIES
			$id = $this->input->get('id', true);
			$banner_data=$this->advertising_model->get_banner($id);
			$campaign_data=$this->advertising_model->get_campaign($banner_data['campaign_id']);
			//CHECK IF CLIENT IS FROM USERS MANAGMENT AREA
			if($this->advertising_model->check_rights_campaign($campaign_data['id'],$country)){
				if($this->advertising_model->delete_banner($id)){
					//PUTANJA DO SADRZAJA
					$dir=FCPATH.'banners/'.$campaign_data['id'].'/'.$id.'/';
					if(is_dir($dir)){
						//OTKRIVANJE SVIH SADRZAJA U DIREKTORIJU
						$files = new RecursiveIteratorIterator(
						    new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS),
						    RecursiveIteratorIterator::CHILD_FIRST
						);
						//BRISANJE SVEGA
						foreach ($files as $fileinfo) {
						    $todo = ($fileinfo->isDir() ? 'rmdir' : 'unlink');
						    $todo($fileinfo->getRealPath());
						}
						//BRISANJE SAMOG DIREKTORIJA
						rmdir($dir);
					}
					$response = array(
								'response' => 'Banner deleted',
								'success' => 1
							);
				}
				else{
					$response = array(
								'response' => 'Banner not deleted',
								'success' => 0
							);
					}
			}
			echo json_encode($response);
			}
		}

	function _banner_views($id){
			$result=$this->advertising_model->stat_count_banners_views_by_date($id);
			//echo $this->db->last_query();
			$tmp_count=array();
			foreach($result as $cl){
				$tmp_count[]='['.(strtotime($cl['date'])*1000).','.$cl['num'].']';
			}
			$tmp_count=implode(',',$tmp_count);
			$tmp_count='['.$tmp_count.']';
			return $tmp_count;
	}
	
	function _banner_clicks($id){
			$result=$this->advertising_model->stat_count_banners_clicks_by_date($id);
			//echo $this->db->last_query();
			$tmp_count=array();
			foreach($result as $cl){
				$tmp_count[]='['.(strtotime($cl['date'])*1000).','.$cl['num'].']';
			}
			$tmp_count=implode(',',$tmp_count);
			$tmp_count='['.$tmp_count.']';
			return $tmp_count;
	}

	function _campaign_views($id){
			$result=$this->advertising_model->stat_count_campaign_views_by_date($id);
			//echo $this->db->last_query();
			$tmp_count=array();
			foreach($result as $cl){
				$tmp_count[]='['.(strtotime($cl['date'])*1000).','.$cl['num'].']';
			}
			$tmp_count=implode(',',$tmp_count);
			$tmp_count='['.$tmp_count.']';
			return $tmp_count;
	}
	
	function _campaign_clicks($id){
			$result=$this->advertising_model->stat_count_campaign_clicks_by_date($id);
			//echo $this->db->last_query();
			$tmp_count=array();
			foreach($result as $cl){
				$tmp_count[]='['.(strtotime($cl['date'])*1000).','.$cl['num'].']';
			}
			$tmp_count=implode(',',$tmp_count);
			$tmp_count='['.$tmp_count.']';
			return $tmp_count;
	}

/* TEMP START */
	function _count_listings() {
		$count_listings = $this->listings_model->stat_count_listings_by_date();
		//echo $this->db->last_query();
		$tmp_count = array();
		foreach ($count_listings as $cl) {
			$tmp_count[] = '[' . (strtotime($cl['date']) * 1000) . ',' . $cl['num'] . ']';
		}
		$tmp_count = implode(',', $tmp_count);
		$tmp_count = '[' . $tmp_count . ']';
		return $tmp_count;
	}

	/* TEMP END */
	
	
	

    public function process_client() {
        if ($this->require_role_admin('admin,manager')) {
        	$this->load->library('encrypt');
			$id=$this->input->post('client_id',true);
			$contact_data=$this->input->post('cd',true);
			$base_data=array(
				'client_name'=>$this->input->post('client_name',true),
				'country'=>$this->input->post('country',true),
				'contact_data'=> $this->encrypt->encode(json_encode($contact_data), md5($this->advertising_key.$id)),
				'contact_email'=>$this->input->post('contact_email',true)
			);
			
			if($this->advertising_model->update_client($id,$base_data)){
				$response=array(
						'main_data'=>1,
						'response' => 'Client updated!'
					);
			}
			else{
				$response=array(
						'main_data'=>0,
						'response' => 'Client not updated!'
					);
			}
		//OUTPUT RESULT
		echo json_encode($response);
		}
    }

    public function process_campaign() {
        if ($this->require_role_admin('admin,manager')) {
        	$id=$this->input->post('campaign_id',true);
			$base_data=array(
				'name'=>$this->input->post('campaign_name',true),
				'client_id'=>$this->input->post('client',true),
				'start_datetime'=>date('Y-m-d h:i:s',strtotime($this->input->post('date_start',true))),
				'end_datetime'=> date('Y-m-d h:i:s',strtotime($this->input->post('date_end',true))),
				'active'=> $this->input->post('published')?'1':'0'
			);
			
			if($this->advertising_model->update_campaign($id,$base_data)){
				$response=array(
						'main_data'=>1,
						'response' => 'Campaign updated!'
					);
			}
			else{
				$response=array(
						'main_data'=>0,
						'response' => 'Campaign not updated!'
					);
			}
		//OUTPUT RESULT
		echo json_encode($response);
        }
    }
	
	//BANNER
	public function get_ajax_positions(){
		if ($this->require_role_admin('admin,manager')) {
     		   	$location=$this->input->get('location',true);
				$selected=$this->input->get('selected',true);
				$positions=$this->advertising_model->get_positions($location);
				if(!empty($positions)){
					foreach($positions as $p){
						if($selected>0 && $p['id']==$selected)
							echo '<option value="'.$p['id'].'" selected="selected">'.$p['name'].'</option>';
						else
							echo '<option value="'.$p['id'].'">'.$p['name'].'</option>';
					}
				}
		}
	}
	public function process_banner() {
        if ($this->require_role_admin('admin,manager')) {
     		$id=$this->input->post('banner_id',true);
			$base_data=array(
				'campaign_id'=>$this->input->post('campaign_id',true),
				'target_country'=>$this->input->post('target_country',true),
				'target_country'=>$this->input->post('target_country',true),
				'file_type'=>$this->input->post('file_type',true),
				'type'=>$this->input->post('type',true),
				'position'=>$this->input->post('position',true),
				'redirect_url'=>prep_url($this->input->post('redirect_url',true)),
				'target_value'=>$this->input->post('target_value',true),
			);
			if($this->advertising_model->update_banner($id,$base_data)){
				//CATEGORIES
				if($bann_cat=$this->input->post('bann_cat')){
					//REMOVE ALL
					$this->advertising_model->purge_banner_categories($id);
					foreach($bann_cat as $key=>$bc){
						$cb_data=array(
							'banner_id'=>$id,
							'category_id'=>$key
						);
						
						//INSERT NEW ONES
						$this->advertising_model->insert_banner_category($cb_data);
					}
				}
				$response=array(
						'main_data'=>1,
						'response' => 'Banner updated!'
					);
			}
			else{
				$response=array(
						'main_data'=>0,
						'response' => 'Banner not updated!'
					);
			}
		//OUTPUT RESULT
		echo json_encode($response);
		}
	}
	
	public function upload_banner() {
        if ($this->require_role_admin('admin,manager')) {
        	if (!empty($_FILES)) {
					$file = $_FILES['file'];
					$tempFile = $file['tmp_name'];
					$campaign_id=$this->input->get('campaign_id');
					$banner_id=$this->input->get('banner_id');
					
					$path = $this->check_folder($campaign_id . '/' . $banner_id );
					//GENERATE INDEX.HTML TO PREVENT DIRECT ACCESS
					$security_index = $path . '/index.html';
					if (!file_exists($security_index)) {
						$msg = "You don't have premissions to access this location.";
						file_put_contents($security_index, $msg);
					}
					$original_name = $file['name'];
					$fn = $this->safeName($file['name'],$banner_id);
					$file_path = $path . '/' . $fn;


					if (move_uploaded_file($file['tmp_name'], $file_path)) {
						//ONLY READ PREMISSIONS
						chmod($file_path, 0644);
						//SAVE TO DB
						$base_data=array(
							'banner_location'=>$file_path
						);
						$this->advertising_model->update_banner($banner_id,$base_data);
						//DISTINCT DOCUMENTS AND PHOTOS
						$file_info = pathinfo($file_path);
						$extension = $file_info['extension'];
						$banners = array(
							'jpeg',
							'jpg',
							'png',
							'JPG',
							'JPEG',
							'swf',
							'SWF'
						);
						if (is_int(array_search($extension, $banners))) {

							if(is_int(array_search($extension, array('swf','SWF'))))
								$file_type='flash';
							else
								$file_type='image';

							//GENERAL RESPONSE
							$response = array(
								'status' => 1,
								'message' => 'File uploaded',
								'file_type' => $file_type,
								'banner_id' => $banner_id,
								'file_path' => $file_info['dirname'].'/'.$file_info['basename'],
								'file_info' => $file_info
							);
						//IF NOT ALLOWED IMAGE OR DOCUMENT
						}else {
							$response = array(
								'status' => 0,
								'message' => 'File type not allowed',
							);
							echo json_encode($response);
							die();
						}

					} else {
						$response = array(
							'status' => 0,
							'message' => 'Upload failed'
						);
					}
				}
			}
		echo json_encode($response);
    }
	
	function send_mail($user_id,$message){
		if ($this->require_role_admin('admin,manager')) {
			$this->load->library('email');
			$this->config->load('email');
			
			$this->load->model('user_model');
	        $user_data=$this->user_model->view_user_record($user_id);
			
			//SEND MAIL
			$sent=$this->email->quick_email( array(
						'subject'        => lang('not_mail_title'),
						'email_template' => 'email_templates/notification',
						'from_name'      => 'no_reply_email_config',
						'template_data'  => array( 'message' => $message ),
						'to'             => $user_data->user_email
					) );
					
			if($sent){
				$response = array(
					'status' => '1',
					'message' => 'Message sent'
				);
			}
			else{
				$response = array(
					'status' => '0',
					'message' => 'Message not sent'
				);
			}
			echo json_encode($response);
        }
	}

    /*
     * DOHVAĆANJE PODATAKA ZA PREGLED U DATAGRIDU
     */
    public function clients_datagrid() {
        //Active
        if ($this->input->get('active') != '')
            $active = $this->input->get('active', true);
        else
            $active = null;
        //Type
        if ($this->input->get('type') != 0)
            $type = $this->input->get('type', true);
        else
            $type = NULL;
        //Country
        if ($this->input->get('country') != 0)
            $country = $this->input->get('country', true);
        else
            $country = NULL;

        if ($this->require_role_admin('admin,manager')) {
            //COUNT SE PROVODI PO DEFAULT JEZIKU 1
            $count = $this->advertising_model->count_clients($country, $type, $active);
            //DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
            $param_list = array('client_name as client_name', 'added_datetime', 'c.name', 'active', 'acl.id as edit_id', 'acl.id as delete_id');
            $query = $this->advertising_model->get_clients_datagrid($param_list, $country, $type, $active);
            $data = array();
            if (!empty($query)) {
                foreach ($query as $q) {
                    //OBLIKOVANJE PODATAKA ZA ISPIS
                    $q['client_name'] = htmlspecialchars($q['client_name']);
                    $q['added_datetime'] = date('d.m.Y.', strtotime($q['added_datetime']));
                    $data['aaData'][] = array_values($q);
                }
            } else {
                $data['aaData'] = array();
            }
            echo json_encode($data);

        }

    }

    public function campaigns_datagrid() {
        //client
        if ($this->input->get('client') != '')
            $client = $this->input->get('client', true);
        else
            $client = null;

        if ($this->require_role_admin('admin,manager')) {
            //COUNT SE PROVODI PO DEFAULT JEZIKU 1
            $count = $this->advertising_model->count_campaigns($client);
            //DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
            $param_list = array('name', 'client_name', 'start_datetime', 'end_datetime', 'acm.id as edit_id', 'acm.id as delete_id');
            $query = $this->advertising_model->get_campaigns_datagrid($param_list, $client);
            $data = array();
            if (!empty($query)) {
                foreach ($query as $q) {
                    //OBLIKOVANJE PODATAKA ZA ISPIS
                    $q['name'] = htmlspecialchars($q['name']);
                    $q['client_name'] = htmlspecialchars($q['client_name']);
                    $q['start_datetime'] = date('d.m.Y.', strtotime($q['start_datetime']));
                    $q['end_datetime'] = date('d.m.Y.', strtotime($q['end_datetime']));
                    $data['aaData'][] = array_values($q);
                }
            } else {
                $data['aaData'] = array();
            }
            echo json_encode($data);

        }

    }

	private function check_folder($path) {
		$real_path = 'banners/' . $path;
		if (is_dir($real_path)) {
			return $real_path;
		} else {
			//ONLY WEB SERVER CAN ACCESS 0700
			if (mkdir($real_path, 0755, true))
				return $real_path;
			else
				return FALSE;
		}

	}
	
	private function safeName($string,$banner_id) {
		$path_info = pathinfo($string);
		$extension = $path_info['extension'];
		$name = $path_info['filename'];
		$not_allowed = array(
			'php',
			'html',
			'js',
			'jsp'
		);
		if (is_int(array_search($extension, $not_allowed))) {
			die('FILE TYPE NOT ALLOWED');
		}
		$string = md5($banner_id);
		return $string . '.' . $extension;
	}

}
